import javax.swing.*;
import java.awt.*;
import java.awt.geom.*;
import java.awt.image.*;

/** Przykad wykorzystania obiektu TexturePaint do wypeniania obiektw teksturami zoonymi
 *  z uoonych obok siebie rysunkw. Pobranie rysunku z pliku i przeksztacenie go
 *  w obiekt BufferedImage opiera si na metodach dajBuforowanyRysunek oraz 
 *  NarzedziaObslugiRysunkow.
 *
 * Kody zaczerpniete z polskiej edycji        *
 * ksiazki Serwisy internetowe. Programowanie *
 * Wydawnictwo Helion, Gliwice,               *
 * ftp://ftp.helion.pl/przyklady/serinp.zip   *
 * &copy; 2001 Marty Hall and Larry Brown;    *
*/

public class Tekstury extends JPanel {
  private String katalog = System.getProperty("user.dir");
  private String plikRysunku1 = katalog + "/rysunki/surfing.gif";
  private TexturePaint tekstura1;
  private Rectangle obszarRysunku;
  private String plikRysunku2 = katalog + "/rysunki/niebieska_kropla.gif";
  private TexturePaint tekstura2;
  private int[] wspolrzedneX = { 30, 700, 400 };
  private int[] wspolrzedneY = { 30, 30, 600 };
  private Polygon rysunekTrojkata =
                    new Polygon(wspolrzedneX, wspolrzedneY, 3);
  public Tekstury() {
    BufferedImage rysunek =
      NarzedziaObslugiRysunkow.dajBuforowanyRysunek(plikRysunku1, this);
    obszarRysunku = new Rectangle(265, 125, rysunek.getWidth(),
                              rysunek.getHeight());
    tekstura1 = new TexturePaint(rysunek, obszarRysunku);
    rysunek = NarzedziaObslugiRysunkow.dajBuforowanyRysunek(plikRysunku2, this);
    tekstura2 =
      new TexturePaint(rysunek, new Rectangle(0, 0, 32, 32));
  }

  public void paintComponent(Graphics g) {
    super.paintComponent(g);
    Graphics2D g2d = (Graphics2D)g;
    g2d.setPaint(tekstura2);
    g2d.fill(rysunekTrojkata);
    g2d.setPaint(Color.blue);
    g2d.setStroke(new BasicStroke(5));
    g2d.draw(rysunekTrojkata);
    g2d.setPaint(tekstura1);
    g2d.fill(obszarRysunku);
    g2d.setPaint(Color.black);
    g2d.draw(obszarRysunku);
  }

  public static void main(String[] argumenty) {
    NarzedziaOkienkowe.otworzWJFrame(new Tekstury(), 750, 650);
  }
}