import javax.swing.*;
import java.awt.*;
import java.awt.geom.*;

/** Przykad wykorzystania rnych sposobw czenia odcinkw 
 *  oraz zakaczania linii. 
 *  Rodzaj zakoczenia linii zaley od wartoci parametru koniecLinii.
 *
 * Kody zaczerpniete z polskiej edycji        *
 * ksiazki Serwisy internetowe. Programowanie *
 * Wydawnictwo Helion, Gliwice,               *
 * ftp://ftp.helion.pl/przyklady/serinp.zip   *
 * &copy; 2001 Marty Hall and Larry Brown;    *
*/

public class StyleLinii extends JPanel {
  private GeneralPath linia;
  private static int x = 30, deltaX = 100, y = 250,
                     deltaY = 200, szerokosc = 35;
  private Punkt p1Duzy, p1Maly, p2Duzy, p2Maly,
               p3Duzy, p3Maly;
  private int nakladanieObrazu = AlphaComposite.SRC_OVER;
  private AlphaComposite obrazPrzezroczysty =
    AlphaComposite.getInstance(nakladanieObrazu, 0.4F);
  private int[] zakonczenia =
    { BasicStroke.CAP_SQUARE, BasicStroke.CAP_BUTT,
      BasicStroke.CAP_ROUND };
  private String[] nazwyZakonczen =
    { "CAP_SQUARE", "CAP_BUTT", "CAP_ROUND" };
  private int[] laczenia =
    { BasicStroke.JOIN_MITER, BasicStroke.JOIN_BEVEL,
      BasicStroke.JOIN_ROUND };
  private String[] nazwyLaczen =
    { "JOIN_MITER", "JOIN_BEVEL", "JOIN_ROUND" };

  public StyleLinii() {
    linia = new GeneralPath();
    linia.moveTo(x, y);
    p1Duzy = new Punkt(x, y, szerokosc/2);
    p1Maly = new Punkt(x, y, 2);
    linia.lineTo(x + deltaX, y - deltaY);
    p2Duzy = new Punkt(x + deltaX, y - deltaY, szerokosc/2);
    p2Maly = new Punkt(x + deltaX, y - deltaY, 2);
    linia.lineTo(x + 2*deltaX, y);
    p3Duzy = new Punkt(x + 2*deltaX, y, szerokosc/2);
    p3Maly = new Punkt(x + 2*deltaX, y, 2);
    setFont(new Font("SansSerif", Font.BOLD, 16));
  }

  public void paintComponent(Graphics g) {
    super.paintComponent(g);
    Graphics2D g2d = (Graphics2D)g;
    g2d.setColor(Color.lightGray);
    for(int i=0; i<zakonczenia.length; i++) {
      BasicStroke stylLinii =
        new BasicStroke(szerokosc, zakonczenia[i], laczenia[i]);
      g2d.setStroke(stylLinii);
      g2d.draw(linia);
      opiszPunkty(g2d, nazwyZakonczen[i], nazwyLaczen[i]);
      g2d.translate(3*x + 2*deltaX, 0);
    }
  }

  // Wywietlenie pprzezroczystych k umoliwiajcych
  // zaobserwowanie rodzajw zakocze linii.
  // Doczenie opisw zakocze i cze.
  private void opiszPunkty(Graphics2D g2d, String nazwaZakonczenia,
                              String nazwaLaczenia) {
    Paint poczatkowyStyl = g2d.getPaint();
    Composite poczatkowaPrzezroczystosc = g2d.getComposite();
    g2d.setPaint(Color.black);
    g2d.setComposite(obrazPrzezroczysty);
    g2d.fill(p1Duzy);
    g2d.fill(p2Duzy);
    g2d.fill(p3Duzy);
    g2d.setPaint(Color.yellow);
    g2d.setComposite(poczatkowaPrzezroczystosc);
    g2d.fill(p1Maly);
    g2d.fill(p2Maly);
    g2d.fill(p3Maly);
    g2d.setPaint(Color.black);
    g2d.drawString(nazwaZakonczenia, x + szerokosc - 5, y + 5);
    g2d.drawString(nazwaLaczenia, x + deltaX + szerokosc - 5,
                   y - deltaY);
    g2d.setPaint(poczatkowyStyl);
  }

  public static void main(String[] argumenty) {
    NarzedziaOkienkowe.otworzWJFrame(new StyleLinii(),
                                 9*x + 6*deltaX, y + 60);
  }
}

class Punkt extends Ellipse2D.Double {
  public Punkt(double xSrodka, double ySrodka, double promien) {
    super(xSrodka - promien, ySrodka - promien, 2.0*promien,
          2.0*promien);
  }
}