import javax.swing.*;
import java.awt.*;
import java.awt.geom.*;

/** Przykad wykorzystania klasy AlphaComposite do 
 *  wywietlania czciowo przejrzystych rysunkw.
 *
 * Kody zaczerpniete z polskiej edycji        *
 * ksiazki Serwisy internetowe. Programowanie *
 * Wydawnictwo Helion, Gliwice,               *
 * ftp://ftp.helion.pl/przyklady/serinp.zip   *
 * &copy; 2001 Marty Hall and Larry Brown;    *
*/

public class PrzykladPrzezroczystosci extends JPanel {
  private static int odstep=10, szerokosc=60, przesuniecie=20,
                     deltaX=odstep+szerokosc+przesuniecie;
  private Rectangle
    niebieskiKwadrat = new Rectangle(odstep+przesuniecie, odstep+przesuniecie, szerokosc,
                               szerokosc),
    czerwonyKwadrat = new Rectangle(odstep, odstep, szerokosc, szerokosc);

  private AlphaComposite wyznaczenieWspolczynnika(float alfa) {
    int typ = AlphaComposite.SRC_OVER;
    return(AlphaComposite.getInstance(typ, alfa));
  }

  private void rysowanieKwadratow(Graphics2D g2d, float alfa) {
    Composite pierwotnyWspolczynnik = g2d.getComposite();
    g2d.setPaint(Color.blue);
    g2d.fill(niebieskiKwadrat);
    g2d.setComposite(wyznaczenieWspolczynnika(alfa));
    g2d.setPaint(Color.red);
    g2d.fill(czerwonyKwadrat);
    g2d.setComposite(pierwotnyWspolczynnik);
  }

  public void paintComponent(Graphics g) {
    super.paintComponent(g);
    Graphics2D g2d = (Graphics2D)g;
    for(int i=0; i<11; i++) {
      rysowanieKwadratow(g2d, i*0.1F);
      g2d.translate(deltaX, 0);
    }
  }

  public static void main(String[] argumenty) {
    String tytul = "Operowanie przezroczystoci: " +
		   "wspczynniki alfa czerwonych kwadratw " +
                   "przyjmuj wartoci od 0.0 " +
                   "do 1.0. Dolne (niebieskie) kwadraty "+
                   "s nieprzezroczyste.";
                   
    NarzedziaOkienkowe.otworzWJFrame(new PrzykladPrzezroczystosci(),
                                 11*deltaX + 2*odstep,
                                 deltaX + 3*odstep,
                                 tytul, Color.lightGray);
  }
}