import javax.swing.*;
import java.awt.*;
import java.awt.geom.*;

/** Przykad pochylenia kwadratu. 
 *
 * Kody zaczerpniete z polskiej edycji        *
 * ksiazki Serwisy internetowe. Programowanie *
 * Wydawnictwo Helion, Gliwice,               *
 * ftp://ftp.helion.pl/przyklady/serinp.zip   *
 * &copy; 2001 Marty Hall and Larry Brown;    *
*/


public class Pochylenie extends JPanel {
  private static int odstep=10, szerokosc=100;
  private Rectangle kwadrat = new Rectangle(odstep, odstep, 100, 100);

  public void paintComponent(Graphics g) {
    super.paintComponent(g);
    Graphics2D g2d = (Graphics2D)g;
    for (int i=0; i<5; i++) {
      g2d.setPaint(Color.red);
      g2d.fill(kwadrat);
      // Wspczynnik x pochylenia kadego kolejnego kwadratu jest zwikszany o 0.2
      g2d.shear(0.2, 0.0);
      g2d.translate(2*odstep + szerokosc, 0);
    }
  }

  public static void main(String[] argumenty) {
    String tytul =
      "Pochylenie: wspczynnik pochylenia x zmienia si od wartoci 0.0 (lewy kwadrat)" +
      " do 0.8 (prawy kwadrat).";
    NarzedziaOkienkowe.otworzWJFrame(new Pochylenie(),
                                 20*odstep + 5*szerokosc, 
                                 5*odstep + szerokosc,
                                 tytul);
  }
}