import java.awt.*;
import java.awt.image.*;

/** Klasa uatwiajca realizacj typowych zada przetwarzania plikw graficznych,
 *  w tym  tworzenia obiektu BufferedImage na podstawie pliku
 *  rysunku oraz wykorzystania klasy MediaTracker do jednoczesnego 
 *  pobierania wikszej liczby plikw.
 *  
 * Kody zaczerpniete z polskiej edycji        *
 * ksiazki Serwisy internetowe. Programowanie *
 * Wydawnictwo Helion, Gliwice,               *
 * ftp://ftp.helion.pl/przyklady/serinp.zip   *
 * &copy; 2001 Marty Hall and Larry Brown;    *
*/

public class NarzedziaObslugiRysunkow {
  
  /** Pobranie rysunku z pliku i przeksztacenie go w obiekt
   *  BufferedImage.
   */

  public static BufferedImage dajBuforowanyRysunek(String plikRysunku,
                                               Component c) {
    Image rysunek = c.getToolkit().getImage(plikRysunku);
    oczekiwanieNaRysunek(rysunek, c);

    BufferedImage buforowanyRysunek =
      new BufferedImage(rysunek.getWidth(c), rysunek.getHeight(c),
                        BufferedImage.TYPE_INT_RGB);
    Graphics2D g2d = buforowanyRysunek.createGraphics();
    g2d.drawImage(rysunek, 0, 0, c);
    return(buforowanyRysunek);
  }

  /** Metoda ta pobiera rysunek z pliku czekujc na zakoczenie procesu adowania
   *  (standardowa aplikacja klasy MediaTracker).
   *  Nie naley wywoywa tej metody do pobierania wikszej liczby
   *  plikw. Do jednoczenego adowania wielu rysunkw suy druga
   *  wersja niniejszej metody, ktra pobiera tablic rysunkw.
   */

  public static boolean oczekiwanieNaRysunek(Image rysunek, Component c) {
    MediaTracker nadzorca = new MediaTracker(c);
    nadzorca.addImage(rysunek, 0);
    try {
      nadzorca.waitForAll();
    } catch(InterruptedException ie) {}
    return(!nadzorca.isErrorAny());
  }

  /** Metoda ta pobiera rysunki z okrelonych plikw oczekujc na zakoczenie
   *  procesu adowania (standardowa aplikacja klasy MediaTracker)
   */

  public static boolean oczekiwanieNaRysunki(Image[] rysunki, Component c)   {
    MediaTracker nadzorca = new MediaTracker(c);
    for(int i=0; i<rysunki.length; i++)
      nadzorca.addImage(rysunki[i], 0);
    try {
      nadzorca.waitForAll();
    } catch(InterruptedException ie) {}
    return(!nadzorca.isErrorAny());
  }
}