import java.applet.Applet;
import java.awt.*;

/** W tej wersji apletu, dziki zastosowaniu klasy MediaTracker
 *  usunito problem przedwczesnego krelenia ramki. Wymiary rysunku
 *  s ustalane dopiero po cakowitym pobraniu pliku
 *
 * Kody zaczerpniete z polskiej edycji        *
 * ksiazki Serwisy internetowe. Programowanie *
 * Wydawnictwo Helion, Gliwice,               *
 * ftp://ftp.helion.pl/przyklady/serinp.zip   *
 * &copy; 2001 Marty Hall and Larry Brown;    *
*/

public class PoprawionyRysunekWRamce extends Applet {
  private int szerokoscRysunku, wysokoscRysunku;
  private Image rysunek;

  public void init() {
    String nazwaRysunku = getParameter("RYSUNEK");
    if (nazwaRysunku != null) {
      rysunek = getImage(getDocumentBase(), nazwaRysunku);
    } else {
      rysunek = getImage(getDocumentBase(), "blad.gif");
    }
    setBackground(Color.white);
    MediaTracker nadzorca = new MediaTracker(this);
    nadzorca.addImage(rysunek, 0);
    try {
      nadzorca.waitForAll();
    } catch(InterruptedException ie) {}
    if (nadzorca.isErrorAny()) {
      System.out.println("Bd podczas pobierania pliku rysunku");
    }

    // Pobranie wartoci jest przeprowadzone poprawnie - rysunek jest w peni zaadowany
    szerokoscRysunku = rysunek.getWidth(this);
    wysokoscRysunku = rysunek.getHeight(this);
  }

  public void paint(Graphics g) {
    g.drawImage(rysunek, 0, 0, this);
    g.drawRect(0, 0, szerokoscRysunku, wysokoscRysunku);
  }
}