import java.awt.*;

/** Klasa narzdziowa, ktra umoliwia pobieranie i oczekiwanie na pene
 *  zaadowanie rysunku lub kilku rysnkw. Stosowanie metody oczekiwanieNaRysunek
 *  do pobierania kilku plikw jest uzasadnione tylko w niektrych przypadkach, kiedy
 *  rysunki <b>musz<b> by adowane kolejno. W pozostaych sytuacjach naley
 *  korzysta z metody oczekiwanieNaRysunki, ktra pobiera kilka plikw rwnolegle,
 *  co skutkuje szybszym dziaaniem programu.
 *
 * Kody zaczerpniete z polskiej edycji       *
 * ksiazki Serwisy internetowe. Programowanie *
 * Wydawnictwo Helion, Gliwice,               *
 * ftp://ftp.helion.pl/przyklady/serinp.zip   *
 * &copy; 2001 Marty Hall and Larry Brown;    *
*/

public class ObslugaRysunkow {
  public static boolean oczekiwanieNaRysunek(Image rysunek, Component c) {
    MediaTracker nadzorca = new MediaTracker(c);
    nadzorca.addImage(rysunek, 0);
    try {
      nadzorca.waitForAll();
    } catch(InterruptedException ie) {}
    if (nadzorca.isErrorAny()) {
      return(false);
    } else {
      return(true);
    }
  }

  public static boolean oczekiwanieNaRysunki(Image[] rysunki,
                                      Component c) {
    MediaTracker nadzorca = new MediaTracker(c);
    for(int i=0; i<rysunki.length; i++) {
      nadzorca.addImage(rysunki[i], 0);
    }
    try {
      nadzorca.waitForAll();
    } catch(InterruptedException ie) {}
    if (nadzorca.isErrorAny()) {
      return(false);
    } else {
      return(true);
    }
  }
}