import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.net.*;

/** Klasa umoliwiajca porwnanie czasu wywietlenia rysunku poddanego buforowaniu
 *  (getImage, prepareImage, and drawImage) i czasu wywietlania rysunku standardowymi metodami 
 *  (getImage and drawImage).
 *  <P>
 *  Wynik uzyskany przy zastosowaniu standardowych metod zaley 
 *  od jakoci poczenia sieciowgo oraz od rozmiaru pliku graficznego.
 *  Czas uzyskany w wyniku buforowania rysunku zaley jedynie
 *  od szykoci danego komputera, przy zaoeniu, e od chwili
 *  zaadowania apletu do chwili kliknicia przycisku upywa 
 *  "znaczna" ilo czasu (porwnywalna z czasem potrzebnym na
 *  pobranie pliku).
 *
 *
 * Kody zaczerpniete z polskiej edycji        *
 * ksiazki Serwisy internetowe. Programowanie *
 * Wydawnictwo Helion, Gliwice,               *
 * ftp://ftp.helion.pl/przyklady/serinp.zip   *
 * &copy; 2001 Marty Hall and Larry Brown;    *
*/

public class Buforowanie extends JPanel implements ActionListener {

  private JTextField poleCzasu;
  private long start = 0;
  private boolean wyswietl = false;
  private JButton przycisk;
  private Image rysunek;

  public Buforowanie(String plikRysunku, boolean buforowanie) {
    setLayout(new BorderLayout());
    przycisk = new JButton("Wywietl rysunek");
    przycisk.setFont(new Font("SansSerif", Font.BOLD, 24));
    przycisk.addActionListener(this);
    JPanel panelSterowania = new JPanel();
    panelSterowania.add(przycisk);
    poleCzasu = new JTextField(25);
    poleCzasu.setEditable(false);
    poleCzasu.setFont(new Font("SansSerif", Font.BOLD, 24));
    panelSterowania.add(poleCzasu);
    add(panelSterowania, BorderLayout.SOUTH);
    zarejestrujRysunek(plikRysunku, buforowanie);

  }

  /** Nie trzeba sprawdza jaki obiekt wygenerowa zdarzenie,
   *  gdy moe ono pochodzi tylko od przycisku.
   */

  public void actionPerformed(ActionEvent event) {
    wyswietl = true;
    start = System.currentTimeMillis();
    repaint();
  }

  // Wywoanie getImage; opcjonalnie, rozpoczcia adowania rysunku.

  private void zarejestrujRysunek(String plikRysunku, boolean buforowanie) {
    try {
      rysunek = getToolkit().getImage(new URL(plikRysunku));
      if (buforowanie) {
        prepareImage(rysunek, this);
      }
    } catch(MalformedURLException mue) {
      System.out.println("Niewaciwy adres URL: " + mue);
    }
  }

  /** Jeeli przycisk zosta kliknity, metoda ta wywietla rysunek i
   *  informacj o czasie jaki upyn. W przeciwnym przypadku nie s 
   *  podejmowane adne dziaania.
   */

  public void paintComponent(Graphics g) {
    super.paintComponent(g);
    if (wyswietl) {
      g.drawImage(rysunek, 0, 0, this);
      wyswietlCzas();
    }
  }

  // Metoda wywietla w polu tekstowym czas jaki upyn od kliknicia przycisku.

  private void wyswietlCzas() {
    poleCzasu.setText("Czas [sek.]: " + uplynelo());
  }

  // Ustalenie ile sekund upyno od chwili kliknicia przycisku.

  private double uplynelo() {
    double delta = (double)(System.currentTimeMillis() - start);
    return(delta/1000.0);
  }

  public static void main(String[] argumenty) {
    JPanel buforowanie;

    if (argumenty.length == 0) {
      System.out.println("Musisz poda adres URL");
      System.exit(0);
    }
    if (argumenty.length == 2 && argumenty[1].equals("-buforowanie")) {
      buforowanie = new Buforowanie(argumenty[0], true);
    } else {
      buforowanie = new Buforowanie(argumenty[0], false);
    }

    NarzedziaOkienkowe.ustawWygladSystemowy();
    NarzedziaOkienkowe.otworzWJFrame(buforowanie, 1000, 750);
  }
}