import java.util.Vector;

/** Struktura danych reprezentujca wze drzewa binarnego.
 *  Skada si z wartoci wza oraz referencji (wskanikw) do
 *  lewego i prawego poddrzewa.
 *
 *  Kody zaczerpniete z polskiej edycji        *
 *  ksiazki Serwisy internetowe. Programowanie *
 *  Wydawnictwo Helion, Gliwice,               *
 *  ftp://ftp.helion.pl/przyklady/serinp.zip   *
 *  &copy; 2001 Marty Hall and Larry Brown;    *
 */

public class Wezel {
  private Object wartoscWezla;
  private Wezel lewyPotomek, prawyPotomek;

 /** Powoanie obiektu z okrelon wartoci wza i poddrzewami. */
 
  public Wezel(Object wartoscWezla, Wezel lewyPotomek,
              Wezel prawyPotomek) {
    this.wartoscWezla = wartoscWezla;
    this.lewyPotomek = lewyPotomek;
    this.prawyPotomek = prawyPotomek;
  }

  /** Powoanie wza o okrelonej wartoci i lewym poddrzewie. Prawe poddrzewo
   *  ma warto null. Jeeli obydwa elementy potomne powinny mie warto null,
   *  naley wykorzysta konstruktor licia.
   */

  public Wezel(Object wartoscWezla, Wezel lewyPotomek) {
    this(wartoscWezla, lewyPotomek, null);
  }

  /** Zwrcenie wartoci wza. */

  public Object dajWartoscWezla() {
    return(wartoscWezla);
  }

  /** Ustawienie wartoci wza. */

  public void ustawWartoscWezla(Object wartoscWezla) {
    this.wartoscWezla = wartoscWezla;
  }

 /** Zwrcenie lewego poddrzewa. */

  public Wezel dajLewyPotomek() {
    return(lewyPotomek);
  }

  /** Ustawienie lewego poddrzewa. */

  public void ustawLewyPotomek(Wezel lewyPotomek) {
    this.lewyPotomek = lewyPotomek;
  }

  /** Zwrcenie prawego poddrzewa. */

  public Wezel dajPrawyPotomek() {
    return(prawyPotomek);
  }

  /** Ustawienie prawego poddrzewa. */

  public void ustawPrawyPotomek(Wezel prawyPotomek) {
    this.prawyPotomek = prawyPotomek;
  }

  /** Przechodzenie przez elementy drzewa w porzdku zstpujcym. Na kadym z analizowanych
   *  wzw wykonywana jest okrelona operacja.
   */

  public void przeszukiwanieZstepujace(OperacjaNaWezle op) {
    op.wykonajNa(this);
    if (lewyPotomek != null) {
      lewyPotomek.przeszukiwanieZstepujace(op);
    }
    if (prawyPotomek != null) {
      prawyPotomek.przeszukiwanieZstepujace(op);
    }
  }

  /** Przechodzenie przez elementy drzewa w porzdku rozszerzajcym. Na kadym z analizowanych
   *  wzw wykonywana jest okrelona operacja.
   */

  public void przeszukiwanieRozszerzajace(OperacjaNaWezle op) {
    Vector kolejkaWezlow = new Vector();
    kolejkaWezlow.addElement(this);
    Wezel wezel;
    while(!kolejkaWezlow.isEmpty()) {
      wezel = (Wezel)kolejkaWezlow.elementAt(0);
      kolejkaWezlow.removeElementAt(0);
      op.wykonajNa(wezel);
      if (wezel.dajLewyPotomek() != null) {
        kolejkaWezlow.addElement(wezel.dajLewyPotomek());
      }
      if (wezel.dajPrawyPotomek() != null) {
        kolejkaWezlow.addElement(wezel.dajPrawyPotomek());
      }
    }
  }
}