import java.io.*;

/** Klasa uatwiajca uruchamianie zewntrznych procesw z poziomu
 *  projektowanych aplikacj. Klasa oferuje trzy sposoby uruchamiania programw:
 *  <OL>
 *     <LI><B>uruchom</B>: Metoda wykonuje okrelone polecenie i natychmiast
 *         koczy swoje dziaanie, nawet w przypadku gdy zrealizowanie polecenia
 *         zajmuje duszy czas. Metoda ta jest odpowiednia dla zada drukowania plikw.
 *     <LI><B>uruchomZaczekaj</B>: Metoda wykonuje okrelone polecenie ale nie koczy
 *         dziaania do czasu zakoczenia wykonywania polecenia. Metoda ta jest
 *         odpowiednia dla przypadkw sekwencyjnego wywoywania polece, gdzie jedno z polece
 *         zaley od wyniku poprzedniego (np.
 *         <CODE>javac</CODE> i <CODE>java</CODE>).
 *     <LI><B>uruchomWyswietl</B>: Metoda wykonuje okrelone polecenie i wywietla jego wynik.
 *          Metoda ta jest odpowiednia dla polece systemu Unix, np. <CODE>ls</CODE>.
 *  </OL>
 *  Warto zmiennej PATH nie jest uwzgldniana, naley zatem okreli
 *  <B>pen</B> ciek dostpu do pliku polecenia. Wbudowane polecenia interpretera
 *  nie bd dziaa poprawnie. Polecenia w systemie Unix powinny by wywoywane w nastpujcy
 *  sposb:
 *  <OL>
 *    <LI><PRE>Uruchom.uruchom("/usr/ucb/lpr WybranyPlik");</PRE>
 *    <LI><PRE>Uruchom.uruchomZaczekaj("/usr/local/bin/javac Cos.java");
 *        Uruchom.uruchomZaczekaj("/usr/local/bin/java Cos");</PRE>
 *    <LI><PRE>Uruchom.uruchomWyswietl("/usr/bin/ls -al");</PRE>
 *  </OL>
 *
 * Kody zaczerpniete z polskiej edycji        *
 * ksiazki Serwisy internetowe. Programowanie *
 * Wydawnictwo Helion, Gliwice,               *
 * ftp://ftp.helion.pl/przyklady/serinp.zip   *
 * &copy; 2001 Marty Hall and Larry Brown;    *
 */

public class Uruchom {

  private static boolean informuj = true;

  /** Zmienna ta okrela czy klasa Uruchom powinna wywietla informacje o tym, ktre
    * polecenie jest w danej chwili realizowane i generowa komunikaty o bdach
    * w przypadku napotkania jakichkolwiek problemw. Wartoci domyln jest true
    *
    * @param znacznikInformuj true: wywietlanie komunikatw, false: brak komunikatw.
    */

  public static void ustawInformuj(boolean znacznikInformuj) {
    informuj = znacznikInformuj;
  }

  /** Czy bd wywietlane komunikaty statusowe? */

  public static boolean dajInformuj() {
    return(informuj);
  }

  /** Metoda ta uruchamia proces w celu wykonania polecenia, po czym koczy swoje dziaanie,
    * nawet jeli polecenie nie zostao jeszcze zakoczone.
    *
    * @param polecenie <B>Pena </B> cieka dostpu do polecenia, ktre bdzie realizowane.
    * Nie dopuszcza si uycia wbudowanych instrukcji interpretera (np. "cd") lub znakw
    * specjalnych (np. ">").
    * @return false jeeli pojawi si bd. Jednak ze wzgldu na fakt, e metoda koczy prac
    * natychmiast po wywoaniu polecenia, z reguy nie stwierdza si w tym czasie
    * adnych bdw. W przypadku poprawnego wykonania polecenia zwracan wartoci jest true.
    */

  public static boolean uruchom(String polecenie) {
    return(uruchom(polecenie, false, false));
  }

  /** Metoda uruchamia proces w celu wykonania polecenia i oczekuje na zakoczenie
    * polecenia.
    *
    * @param polecenie <B>Pena </B> cieka dostpu do polecenia, ktre bdzie realizowane.
    * Nie dopuszcza si uycia wbudowanych instrukcji interpretera lub znakw
    * specjalnych.
    * @return false jeeli pojawi sie bd sygnalizowany wyjtkiem lub niezerowym
    * kodem zakoczenia wywoywanego programu.
    * W przypadku poprawnego wykonania polecenia zwracan wartoci jest true.
    */

  public static boolean uruchomZaczekaj(String polecenie) {
    return(uruchom(polecenie, false, true));
  }

  /** Metoda ta uruchamia proces w celu wykonania polecenia i wywietla wszystkie komunikaty
    * generowane przez wywoywany program.
    *
    * @param polecenie <B>Pena </B> cieka dostpu do polecenia, ktre bdzie realizowane.
    * Nie dopuszcza si uycia wbudowanych instrukcji interpretera lub znakw
    * specjalnych.
    * @return false jeeli pojawi sie bd sygnalizowany wyjtkiem lub niezerowym
    * kodem zakoczenia wywoywanego programu.
    * W przypadku poprawnego wykonania polecenia zwracan wartoci jest true.
    */

  public static boolean uruchomWyswietl(String polecenie) {
    return(uruchom(polecenie, true, false));
  }

  /** Metoda ta powouje obiekt Process za pomoc Runtime.getRuntime.exec().
    * Na podstawie informacji zawartych w znacznikach, wywouje lub nie metod
    * waitFor (co nie pozwala na zakoczenie metody do czasu zakoczenia procesu).
    * W zalenoci od znacznikw otwiera rwnie strumie danych wejciowych przekazywanych przez proces
    * (co pozwala na pobranie wynikw dziaania programu).
    */

  private static boolean uruchom(String polecenie,
                              boolean wyswietlWyniki,
                              boolean zaczekaj) {
    if (informuj) {
      wyswietlLinie();
      System.out.println("Wykonywane polecenie: '" + polecenie + "'.");
    }
    try {
      // Rozpoczcie wykonywania polecenia i natychmiastowe zakoczenie procedury.
      Process p  = Runtime.getRuntime().exec(polecenie);

      // Wywietlenie wyniku dziaania programu. Poniewa odczyt danych trwa do momentu
      // kiedy wszystkie dane zostan wprowadzone, aplikacja musi zaczeka do zakoczenia procesu.
      if(wyswietlWyniki) {
        BufferedReader bufor = new BufferedReader(
          new InputStreamReader(p.getInputStream()));
        String s = null;
        try {
          while ((s = bufor.readLine()) != null) {
            System.out.println("Wynik: " + s);
          }
          bufor.close();
          if (p.exitValue() != 0) {
            if (informuj) {
              wyswietlBlad(polecenie + " -- p.exitValue() != 0");
            }
            return(false);
          }
        } catch (Exception e) {
          // Bdy odczytu s ignorowane - ich wystpienie oznacza, e poroces si zakoczy.

        }

      // Jeeli wyniki nie s wywietlane, naley wywoa metod waitFor,
      // ktra wstrzyma wykonywanie programu do czasu zakoczenia procesu
      } else if (zaczekaj) {
        try {
          System.out.println(" ");
          int zwracanaWartosc = p.waitFor();
          if (zwracanaWartosc != 0) {
            if (informuj) {
              wyswietlBlad(polecenie);
            }
            return(false);
          }
        } catch (Exception e) {
          if (informuj) {
            wyswietlBlad(polecenie, e);
          }
          return(false);
        }
      }
    } catch (Exception e) {
      if (informuj) {
        wyswietlBlad(polecenie, e);
      }
      return(false);
    }
    return(true);
  }

  private static void wyswietlBlad(String polecenie,
                                 Exception e) {
    System.out.println("Bd podczas wykonywania(" + polecenie + "): " +
                        e.getMessage());
    System.out.println("Czy zostaa podana waciwa scieka dostpu?");
  }

  private static void wyswietlBlad(String polecenie) {
    System.out.println("Bd podczas wykonywania " + polecenie + ".");
  }

  private static void wyswietlLinie() {
    System.out.println
      ("==============================================");
  }
}