import java.io.*;

/** Kody zaczerpniete z polskiej edycji        *
 *  ksiazki Serwisy internetowe. Programowanie *
 *  Wydawnictwo Helion, Gliwice,               *
 *  ftp://ftp.helion.pl/przyklady/serinp.zip   *
 *  &copy; 2001 Marty Hall and Larry Brown;    *
 */

public class UjemnyRozmiarWyjatek extends Exception {

  /** Test wyjtku UjemnyRozmiarWyjatek */

  public static void main(String[] argumenty) {
    try {
      int dlugoscLinii = odczytParametru();
      for(int i=0; i<dlugoscLinii; i++) {
        System.out.print("*");
      }
      System.out.println();
    } catch (UjemnyRozmiarWyjatek urw) {
      System.out.println("UjemnyRozmiarWyjatek: " +
                         urw.getMessage());
    }
  }

  public UjemnyRozmiarWyjatek() {
    super("Rozmiar nie moe mie wartoci ujemnej.");
  }

  public UjemnyRozmiarWyjatek(String komunikat) {
    super(komunikat);
  }

  // metoda odczytParametru przechwytuje lokalnie wyjtek IOExceptions ale umoliwia
  // metodzie wywoujcej obsug wyjtku UjemnyRozmiarWyjatek.
  private static int odczytParametru() throws UjemnyRozmiarWyjatek {
    BufferedReader in = new BufferedReader(
                          new InputStreamReader(System.in));
    System.out.print("Podaj dugo: ");
    System.out.flush();
    int dl = 0;
    try {
      String linia = in.readLine();
      dl = Integer.parseInt(linia);
      if (dl < 0) {
        throw new UjemnyRozmiarWyjatek();
      }
    } catch (IOException ioe) {
      System.out.println("Bd przy wprowadzaniu danych z klawiatury");
    }
    return(dl);
  }
}