import java.net.*; // URL, MalformedURLException
import java.io.*;  // BufferedReader

/** Klasa demonstrujca konstrukcj try-catch. 
 *
 *  Kody zaczerpniete z polskiej edycji        *
 *  ksiazki Serwisy internetowe. Programowanie *
 *  Wydawnictwo Helion, Gliwice,               *
 *  ftp://ftp.helion.pl/przyklady/serinp.zip   *
 *  &copy; 2001 Marty Hall and Larry Brown;    *
 */

public class URLTest {
  public static void main(String[] argumenty) {
    URLTest test = new URLTest();
    test.dajURL();
    test.wyswietlURL();
  }

  private URL url = null;

  /** Odczytanie cigu tekstowego przekazanego przez uytkownika i utworzenie adresu URL.
   *  Jeeli odczyt si nie powidzie, naley wygenerowa raport. Jeeli odczyt si powiedzie
   *  ale adres URL jest niepoprawny, uytkownik moe sprbowa jeszcze raz.
   */

  public URL dajURL() {
    if (url != null) {
      return(url);
    }
    System.out.print("Wprowad adres URL: ");
    System.out.flush();
    BufferedReader in = new BufferedReader(
                          new InputStreamReader(System.in));
    String urlString;
    try {
      urlString = in.readLine();
    } catch(IOException ioe) {
      System.out.println("Bd IOError podczas wprowadzania danych: " + ioe);
      ioe.printStackTrace(); // Wywietlenie stanu stosu.
      return(null);
    }
    try {
      url = new URL(urlString);
    } catch(MalformedURLException mue) {
      System.out.println("Adres " + urlString + " jest niepoprawny.\n" +
                         "Sprbuj ponownie.");
      dajURL();
    }
    return(url);
  }

  /** Wywietlenie informacji o adresie URL. */

  public void wyswietlURL() {
    if (url == null) {
      System.out.println("Brak adresu URL.");
    } else {
      String protokol = url.getProtocol();
      String host = url.getHost();
      int port = url.getPort();
      if (protokol.equals("http") && (port == -1)) {
        port = 80;
      }
      String plik = url.getFile();
      System.out.println("Protok: " + protokol +
                         "\nHost: " + host +
                         "\nPort: " + port +
                         "\nPlik: " + plik);
    }
  }
}