 
/** Kody zaczerpniete z polskiej edycji        *
 *  ksiazki Serwisy internetowe. Programowanie *
 *  Wydawnictwo Helion, Gliwice,               *
 *  ftp://ftp.helion.pl/przyklady/serinp.zip   *
 *  &copy; 2001 Marty Hall and Larry Brown;    *
 */

interface Szczekajace {}

class Ssak {}

class Psowate extends Ssak {}

class Pies extends Psowate implements Szczekajace {}

class PiesMysliwski extends Pies {}

public class InstanceOf {
  public static void main(String[] argument) {
    Psowate wilk = new Psowate();
    PiesMysliwski chart = new PiesMysliwski();

    System.out.println("Sprawdzenie operatora instanceof:");
    informacje(wilk, "wilk");
    System.out.println();
    informacje(chart, "chart");

    System.out.println("\nSprawdzenie metody isInstance:");
    Class szczekajaceClass = Szczekajace.class;
    Class piesClass = Pies.class;
    Class piesMysliwskiClass = PiesMysliwski.class;
    System.out.println("  Czy pies myliwski szczeka? " +
                       szczekajaceClass.isInstance(chart));
    System.out.println("  Czy pies myliwski jest psem? " +
                       piesClass.isInstance(chart));
    System.out.println("  Czy kady pies jest psem myliwskim? " +
                       piesMysliwskiClass.isInstance(new Pies()));
  }

  public static void informacje(Object obiekt, String nazwa) {
    System.out.println("  " + nazwa + " jest ssakiem: " +
                       (obiekt instanceof Ssak));
    System.out.println("  " + nazwa + " naley do psowatych: " +
                       (obiekt instanceof Psowate));
    System.out.println("  " + nazwa + " jest psem: " +
                       (obiekt instanceof Pies));
    System.out.println("  " + nazwa + " jest psem myliwskim: " +
                       (obiekt instanceof PiesMysliwski));
  }
}