/** Kody zaczerpniete z polskiej edycji        *
 * ksiazki Serwisy internetowe. Programowanie *
 * Wydawnictwo Helion, Gliwice,               *
 * ftp://ftp.helion.pl/przyklady/serinp.zip   *
 * &copy; 2001 Marty Hall and Larry Brown;    *
*/

class Statek4 {
  public double x=0.0, y=0.0, predkosc=1.0, kierunek=0.0;
  public String nazwa;

  // Konstruktor pobierajcy wszystkie parametry.
  
  public Statek4(double x, double y, double predkosc,
               double kierunek, String nazwa) {
    this.x = x;
    this.y = y;
    this.predkosc = predkosc;
    this.kierunek = kierunek;
    this.nazwa = nazwa;
  }

  // Konstruktor pobierajcy nazw i przypisujcy wartoci
  // domylne zmiennym x,y, predkosc i kierunek.

  public Statek4(String nazwa) {
    this.nazwa = nazwa;
  }
  
  private double stopnieNaRadiany(double stopnie) {
    return(stopnie * Math.PI / 180.0);
  }

  // Przesunicie o jedn jednostk.
  
  public void przesun() {
    przesun(1);
  }

  // Przesunicie o N jednostek.

 public void przesun(int liczbaJednostek) {
    double kat = stopnieNaRadiany(kierunek);
    x = x + (double)liczbaJednostek * predkosc * Math.cos(kat);
    y = y + (double)liczbaJednostek * predkosc * Math.sin(kat);
  }

  public void pokazPolozenie() {
    System.out.println("Wsprzdne statku " + nazwa + " to ("
                       + x + "," + y + ").");
  }
}

public class Test4 {
  public static void main(String[] argumenty) {
    Statek4 s1 = new Statek4("Statek1"); 
    Statek4 s2 = new Statek4(0.0, 0.0, 2.0, 135.0, "Statek2");
    s1.przesun();
    s2.przesun(3);
    s1.pokazPolozenie();
    s2.pokazPolozenie();
  }
}