/* Kody zaczerpniete z polskiej edycji        *
 * ksiazki Serwisy internetowe. Programowanie *
 * Wydawnictwo Helion, Gliwice,               *
 * ftp://ftp.helion.pl/przyklady/serinp.zip   *
 * &copy; 2001 Marty Hall and Larry Brown;    *
*/

// Dodanie do klasy statku konstruktora, ktry pozwoli na inicjalizacj
// zmiennych obiektowych podczas tworzenia obiektu.

class Statek3 {
  public double x, y, predkosc, kierunek;
  public String nazwa;

  public Statek3(double x, double y, double predkosc,
               double kierunek, String nazwa) {
    this.x = x; // "this" pozwala odrni zmienne obiektowe
    this.y = y; //  od zmiennych lokalnych.
    this.predkosc = predkosc;
    this.kierunek = kierunek;
    this.nazwa = nazwa;
  }
  
  private double stopnieNaRadiany(double stopnie) {
    return(stopnie * Math.PI / 180.0);
  }

 public void przesun() {
    double kat = stopnieNaRadiany(kierunek);
    x = x + predkosc * Math.cos(kat);
    y = y + predkosc * Math.sin(kat);
  }

  public void pokazPolozenie() {
    System.out.println("Wsprzdne statku " + nazwa + " to ("
                       + x + "," + y + ").");
  }
}

public class Test3 {
  public static void main(String[] argumenty) {
    Statek3 s1 = new Statek3(0.0, 0.0, 1.0,   0.0, "Statek1");
    Statek3 s2 = new Statek3(0.0, 0.0, 2.0, 135.0, "Statek2");
    s1.przesun();
    s2.przesun();
    s1.pokazPolozenie();
    s2.pokazPolozenie();
  }
}