/** Klasa Statek - przykad programowania obiektowego w jzyku Java.
 *
 *  @author <A HREF="mailto:larry@corewebprogramming.com">
 *          Larry Brown</A>
 *  @version 2.0
 */

public class Statek {
  // Zmienne obiektowe

  private double x=0.0, y=0.0, predkosc=1.0, kierunek=0.0;
  private String nazwa;

  // Konstruktory

  /** Utworzenie obiektu na podstawie podanych parametrw. */

  public Statek(double x, double y, double predkosc,
                double kierunek, String nazwa) {
    ustawX(x);
    ustawY(y);
    ustawPredkosc(predkosc);
    ustawKierunek(kierunek);
    ustawNazwa(nazwa);
  }

  /** Utworzenie obiektu na podstawie wartoci domylnych
   *  (x=0, y=0, predkosc=1.0, kierunek=0.0).
   */

  public Statek(String nazwa) {
    ustawNazwa(nazwa);
  }

  /** Przesunicie statku o jedn jedostk przy aktualnej prdkoci i kierunku. */

  public void przesun() {
    przesunWewnetrznie(1);
  }

  /** Przesunicie statku o N jednostek. */

  public void przesun(int liczbaJednostek) {
    przesunWewnetrznie(liczbaJednostek);
  }

  private void przesunWewnetrznie(int liczbaJednostek) {
    double kat = stopnieNaRadiany(kierunek);
    x = x + (double)liczbaJednostek * predkosc * Math.cos(kat);
    y = y + (double)liczbaJednostek * predkosc * Math.sin(kat);
  }

  private double stopnieNaRadiany(double stopnie) {
    return(stopnie * Math.PI / 180.0);
  }

  /** Wywietlenie pooenia. */

  public void pokazPolozenie() {
    System.out.println("Wsprzdne statku " + dajNazwa() + " to ("
                       + dajX() + "," + dajY() + ").");
  }

  /** Udostpnienie wartoci wsprzdej X. */

  public double dajX() {
    return(x);
  }

  /** Ustawienie wartoci wsprzdnej X. */

  public void ustawX(double x) {
    this.x = x;
  }

  /** Udostpnienie wartoci wsprzdej Y. */

  public double dajY() {
    return(y);
  }

  /** Ustawienie wartoci wsprzdnej Y. */

  public void ustawY(double y) {
    this.y = y;
  }

  /** Udostpnienie wartoci prdkoci. */

  public double dajPredkosc() {
    return(predkosc);
  }

  /** Ustwienie wartoci predkoci. */

  public void ustawPredkosc(double predkosc) {
    this.predkosc = predkosc;
  }

  /** Udostpnienie informacji o kierunku (0-wschd, 90-pnoc, 180-zachd, 270-poudnie).
   *  Do okrelania kta wykorzystywany jest system matematyczny, a <B>nie</B>
   *  system nawigacyjny, gdzie 0-pnoc, 90-wschd itd.
   */

  public double dajKierunek() {
    return(kierunek);
  }

  /** Ustwienie wartoci kierunku (0-wschd, 90-pnoc, 180-zachd, 270-poudnie).
   *  Do okrelania kta wykorzystywany jest system matematyczny, a <B>nie</B>
   *  system nawigacyjny, gdzie 0-pnoc, 90-wschd itd.
   */


  public void ustawKierunek(double kierunek) {
    this.kierunek = kierunek;
  }

  /** Udostpnienie nazwy statku. Parametr nie moe by zmieniany przez uytkownika. */

  public String dajNazwa() {
    return(nazwa);
  }

  private void ustawNazwa(String nazwa) {
    this.nazwa = nazwa;
  }
}