# 
# /*
#  * *********** WARNING **************
#  * This file generated by ModPerl::WrapXS/0.01
#  * Any changes made here will be lost
#  * ***********************************
#  * 01: lib/ModPerl/Code.pm:709
#  * 02: lib/ModPerl/WrapXS.pm:626
#  * 03: lib/ModPerl/WrapXS.pm:1175
#  * 04: C:\perl\bin\.cpanplus\5.10.0\build\mod_perl-2.0.4\Makefile.PL:423
#  * 05: C:\perl\bin\.cpanplus\5.10.0\build\mod_perl-2.0.4\Makefile.PL:325
#  * 06: C:\perl\bin\.cpanplus\5.10.0\build\mod_perl-2.0.4\Makefile.PL:56
#  * 07: C:\perl\bin\cpanp-run-perl.bat:21
#  */
# 


package APR::Util;

use strict;
use warnings FATAL => 'all';


use APR ();
use APR::XSLoader ();
our $VERSION = '0.009000';
APR::XSLoader::load __PACKAGE__;



1;
__END__

=head1 NAME

APR::Util - Perl API for Various APR Utilities




=head1 Synopsis

  use APR::Util ();
  
  $ok = password_validate($passwd, $hash);




=head1 Description

Various APR utilities that don't fit into any other group.




=head1 API

C<APR::Util> provides the following functions and/or methods:





=head2 C<password_validate>

Validate an encrypted password hash against a plain text password
(with lots of restrictions and peculiarities).

  $ok = password_validate($passwd, $hash);

=over 4

=item arg1: C<$passwd> ( string )

Plain text password string

=item arg2: C<$hash> ( string )

Encrypted or encoded hash. See below for supported hash formats.

=item ret: C<$ok> ( boolean )

The password either matches or not.

=item since: 2.0.00

=back

The function handles the output of the following functions (it knows
to tell md5 and sha1 from the others, since they are have a special
pattern recognized by apr):

=over 4

=item * md5

generated by C<apr_md5_encode()> (for which at the moment we have no
perl glue, ask if you need it).

=item * sha1

generated by C<apr_sha1_base64()> (for which at the moment we have no
perl glue, ask if you need it).

and it's available only since Apache 2.0.50

=item * crypt

On all but the following platforms: MSWin32, beos and
NetWare. Therefore you probably don't want to use that feature, unless
you know that your code will never end up running on those listed
platforms.

Moreover on these three platforms if that function sees that the hash
is not of md5 and sha1 formats, it'll do a clear to clear text
matching, always returning success, no matter what the hashed value
is.

=back

Warning: double check that you understand what this function does and
does not before using it.





=head1 Unsupported API

C<APR::Socket> also provides auto-generated Perl interface for a few
other methods which aren't tested at the moment and therefore their
API is a subject to change. These methods will be finalized later as a
need arises. If you want to rely on any of the following methods
please contact the L<the mod_perl development mailing
list|maillist::dev> so we can help each other take the steps necessary
to shift the method to an officially supported API.





=head2 C<filepath_name_get>

META: Autogenerated - needs to be reviewed/completed

[We have File::Spec and File::Basename for this purpose, I can't see
why this api is needed]

return the final element of the pathname

  $ret = filepath_name_get($pathname);

=over 4

=item arg1: C<$pathname> ( string )

The path to get the final element of

=item ret: C<$ret> ( string )

the final element of the path

For example:

  "/foo/bar/gum"    => "gum"
  "/foo/bar/gum/"   => ""
  "gum"             => "gum"
  "bs\\path\\stuff" => "stuff"

=item since: subject to change

=back






=head2 C<password_get>

META: Autogenerated - needs to be reviewed/completed

Display a prompt and read in the password from stdin.

  $ret = password_get($prompt, $pwbuf, $bufsize);

=over 4

=item arg1: C<$prompt> ( string )

The prompt to display

=item arg2: C<$pwbuf> ( string )

Buffer to store the password

=item arg3: C<$bufsize> (number)

The length of the password buffer.

=item ret: C<$ret> (integer)

=item since: subject to change

=back







=head1 See Also

L<mod_perl 2.0 documentation|docs::2.0::index>.




=head1 Copyright

mod_perl 2.0 and its core modules are copyrighted under
The Apache Software License, Version 2.0.




=head1 Authors

L<The mod_perl development team and numerous
contributors|about::contributors::people>.

=cut

