<?php

/*
======================================================================
Pausing RSS Scroller bridge script
Author: Dynamic Drive (http://www.dynamicdrive.com)
Created: March 16th, 2006.
Function: Converts requested RSS feed from lastRSS into JavaScript array
======================================================================
*/

// include lastRSS
include "lastRSS.php"; //path to lastRSS.php on your server relative to scrollerbridge.php

// Create lastRSS object
$rss = new lastRSS;
$rss->cache_dir = 'cache'; //path to cache directory on your server relative to scrollerbridge.php. Chmod 777!
$rss->date_format = 'M d, Y g:i:s A'; //date format of RSS item. See PHP date() function for possible input.
$rss->cache_time = 1800; //Global cache time before fetching RSS feed again, in seconds.

// Define your list of RSS URLs- "RSS_id"=> "URL to RSS feed"
$rsslist=array(
"seo" => "http://news.google.com/news?pz=1&cf=all&ned=ca&hl=en&q=seo&cf=all&output=rss",
"sem" => "http://www.seowarrior.net/feed/",
"seowarrior" => "http://feeds.feedburner.com/SEOWarrior",
);

//Domains that are authorized to display scroller:
//Seperate multiple domains each with a comma (",")
//For example: $allowedDomains="dynamicdrive.com, javascriptkit.com"
//OR enter a blank string to allow any domain (ie: for RSS feed syndication):
$allowedDomains="";

////Beginners don't need to configure past here////////////////////

Header("content-type: application/x-javascript");
$rssid=$_GET['id'];
$rssurl=isset($rsslist[$rssid])? $rsslist[$rssid] : die("rsscontentdata=\"Error: Can't find requested RSS in list.\"");
$divid=$_GET['divid']; //ID of DIV scroller

// -------------------------------------------------------------------
// checkdomains()- Checks that current site is authorized to display scroller
// -------------------------------------------------------------------

function checkdomains($allowed, $referral){
if ($allowed!=""){
$found=0;
$allowlist=split (",", $allowed);
foreach ($allowlist as $allow){
$allow=trim($allow);
$found+=strpos(" ".$referral, $allow);
}
if (!$found)
die("rsscontentdata=\"This domain isn't authorized to show scroller.\"");
}
}

@checkdomains($allowedDomains, $_SERVER["HTTP_REFERER"]); //check if domain is authorized to display scroller

// -------------------------------------------------------------------
// outputRSS_JS()- Outputs the "title", "link", "description", and "pubDate" elements of an RSS feed in XML format
// -------------------------------------------------------------------

function outputRSS_JS($url, $divid) {
    global $rss;
    if ($rs = $rss->get($url)){
	    echo "rsscontentdata.$divid=new Array();\n";
	    $i=0;
            foreach ($rs['items'] as $item) {
                echo "rsscontentdata.$divid" . "[$i]={link:\"" . slashit($item[link]) . "\", title:\"" . slashit($item[title]) . "\", description:\"" . slashit($item[description]) . "\", date:\"" . slashit($item[pubDate]) . "\"}\n";
		$i++;
            }
            if ($rs['items_count'] <= 0) { echo "rsscontentdata=\"Sorry, no items found in the RSS file\""; }
    }
    else {
        echo "rsscontentdata=\"Sorry: It's not possible to reach RSS file $url\"";
        // All else fails
    }
}

function slashit($what){ //Encode text for storing in JavaScript array
$newstring=str_replace('&apos;', '\'', $what); //replace those half valid apostrophe entities with actual apostrophes
return rawurlencode($newstring);
}

// ===============================================================================

outputRSS_JS($rssurl, $divid);

?>