package com.secookbook.examples.chapter01;

import org.openqa.selenium.ie.InternetExplorerDriver;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.By;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.WebDriverWait;
import org.junit.*;

import static org.junit.Assert.*;

public class GoogleSearchTestOnIE {

	private WebDriver driver;

	@Before
	public void setUp() {
		System.setProperty("webdriver.ie.driver",
				"src/test/resources/drivers/IEDriverServer.exe");

		DesiredCapabilities caps = DesiredCapabilities.internetExplorer();

		caps.setCapability(
				InternetExplorerDriver.INTRODUCE_FLAKINESS_BY_IGNORING_SECURITY_DOMAINS,
				true);

		// Uruchomienie przeglądarki Internet Explorer
		driver = new InternetExplorerDriver(caps);
		//Zmaksymalizuj okno przeglądarki
		driver.manage().window().maximize();
		//Przejdź do Google
		driver.get("http://www.google.com");
	}

	@Test
	public void testGoogleSearch() {
		// Znajdź element wprowadzania tekstu na podstawie jego nazwy
		WebElement element = driver.findElement(By.name("q"));

		// Wpisz informacje do wyszukania
		element.sendKeys("Testowanie z Selenium. Receptury");

		// Teraz prześlij formularz. WebDriver znajdzie
		// formularz na podstawie elementu
		element.submit();

		// Strona wyszukiwania w Google jest dynamicznie renderowana za pomocą JavaScript.
		// Czekamy na załadowanie się strony. Timeout po 10 sekundach.
		new WebDriverWait(driver, 10).until(new ExpectedCondition<Boolean>() {
			public Boolean apply(WebDriver d) {
				return d.getTitle().toLowerCase()
						.startsWith("testowanie z selenium. receptury");
			}
		});

		assertEquals("Testowanie z Selenium. Receptury - Szukaj z Google",
				driver.getTitle());
	}

	@After
	public void tearDown() throws Exception {
		// Zamknij przeglądarkę
		driver.quit();
	}
}

