import unittest
from ddt import ddt, data, unpack
from selenium import webdriver


@ddt
class BmiCalcDDT(unittest.TestCase):
    def setUp(self):
        # utworzenie nowej sesji Firefox
        self.driver = webdriver.Firefox()
        self.driver.implicitly_wait(30)
        self.driver.maximize_window()

        # przejście do strony kalkulatora BMI
        self.driver.get("http://bit.ly/1zdNrFZ")

    # określenie danych testowych z wykorzystaniem dekoratora @data
    @data(("160", "45", "17.6", "Niedowaga"),
          ("168", "70", "24.8", "Waga normalna"),
          ("181", "89", "27.2", "Nadwaga"))
    @unpack
    def test_bmi_calc(self, height, weight, bmi, category):
        driver = self.driver

        height_field = driver.find_element_by_name("heightCMS")
        height_field.clear()
        height_field.send_keys(height)

        weight_field = driver.find_element_by_name("weightKg")
        weight_field.clear()
        weight_field.send_keys(weight)

        calculate_button = driver.find_element_by_id("Oblicz")
        calculate_button.click()

        bmi_label = driver.find_element_by_name("bmi")
        bmi_category_label = driver.find_element_by_name("bmi_category")

        self.assertEqual(bmi, bmi_label.get_attribute("value"))
        self.assertEqual(category, bmi_category_label.get_attribute("value"))

    def tearDown(self):
        # zamknij okno przeglądarki
        self.driver.quit()

if __name__ == '__main__':
    unittest.main(verbosity=2)
