package com.secookbook.examples.chapter10;

import java.io.File;

import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.apache.commons.io.FileUtils;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

import static org.junit.Assert.*;

public class HTML5VideoPlayer {

	private WebDriver driver;

	@Before
	public void setUp() {
		System.setProperty("webdriver.chrome.driver",
				"src/test/resources/drivers/chromedriver.exe");
		
		driver = new ChromeDriver();
		driver.get("http://cookbook.seleniumacademy.com/html5video.html");
	}

	@Test
	public void testHTML5VideoPlayer() throws Exception {
		// Pobranie wartości elementu HTML5 Video
		WebElement videoPlayer = driver.findElement(By.id("vplayer"));

		// Potrzebny jest obiekt JavaScript Executor do interakcji z metodami i właściwościami elementu Video
		// w celu automatyzacji
		JavascriptExecutor jsExecutor = (JavascriptExecutor) driver;

		// Pobranie źródła elementu Video - pliku, który będzie odtwarzany w odtwarzaczu
		String source = (String) jsExecutor.executeScript(
				"return arguments[0].currentSrc;", videoPlayer);
		// Pobranie czasu trwania klipu wideo
		long duration = (Long) jsExecutor.executeScript(
				"return arguments[0].duration", videoPlayer);

		// Zweryfikowanie, czy załadowano właściwy element Video i czy ma odpowiedni czas trwania
		assertEquals("http://html5demos.com/assets/dizzy.mp4", source);
		assertEquals(25, duration);

		// Odtwarzanie wideo
		jsExecutor.executeScript("return arguments[0].play()", videoPlayer);

		Thread.sleep(5000);

		// Pauza na odtwarzaczu
		jsExecutor.executeScript("arguments[0].pause()", videoPlayer);

		// Pobranie zrzutu ekranu w celu późniejszej weryfikacji
		File scrFile = ((TakesScreenshot) driver).getScreenshotAs(OutputType.FILE);
		FileUtils.copyFile(scrFile, new File("target/screenshots/pause_play.png"));
	}

	@After
	public void tearDown() {
		driver.quit();
	}
}

