package com.secookbook.examples.chapter06;

import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.By;

import static org.junit.Assert.*;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class WindowTest {

	public static WebDriver driver;

	@BeforeClass
	public static void setUp() {
		driver = new FirefoxDriver();
		driver.get("http://cookbook.seleniumacademy.com/Config.html");
		driver.manage().window().maximize();
	}

	@Test
	public void testWindowUsingName() {
		// Zapamiętanie uchwytu WindowHandle nadrzędnego okna przeglądarki
		String parentWindowId = driver.getWindowHandle();

		// Kliknięcie przycisku Pomoc otworzy stronę pomocy w nowym oknie podrzędnym
		driver.findElement(By.id("helpbutton")).click();

		try {
			// Przełączenie się do okna pomocy przy użyciu jego nazwy
			driver.switchTo().window("HelpWindow");

			try {
				// Sprawdzenie, czy kontekstem sterownika jest okno pomocy
				assertEquals("Pomoc", driver.getTitle());
			} finally {
				// Zamknięcie okna Pomoc
				driver.close();
			}
		} finally {
			// Przełączenie się do nadrzędnego okna przeglądarki
			driver.switchTo().window(parentWindowId);
		}
		// Sprawdzenie, czy kontekstem sterownika jest nadrzędne okno przeglądarki
		assertEquals("Zbuduj swój samochód - konfiguracja", driver.getTitle());
	}

	@Test
	public void testWindowUsingTitle() {
		// Zapamiętanie uchwytu WindowHandle nadrzędnego okna przeglądarki
		String parentWindowId = driver.getWindowHandle();

		// Kliknięcie przycisku Odwiedź nas spowoduje otwarcie strony Odwiedź nas w nowym oknie potomnym
		driver.findElement(By.id("visitbutton")).click();

		// Pobranie uchwytów wszystkich otwartych okien,
		// iterowanie po liście i sprawdzanie, czy tytuł 
		// każdego okna pasuje do oczekiwanego tytułu okna
		try {
			for (String windowId : driver.getWindowHandles()) {
				String title = driver.switchTo().window(windowId).getTitle();
				if (title.equals("Odwiedź nas")) {
					assertEquals("Odwiedź nas", driver.getTitle());
					// Zamknięcie okna Odwiedź nas
					driver.close();
					break;
				}
			}
		} finally {
			// Przełączenie się do nadrzędnego okna przeglądarki
			driver.switchTo().window(parentWindowId);
		}

		// Sprawdzenie, czy kontekstem sterownika jest nadrzędne okno przeglądarki
		assertEquals("Zbuduj swój samochód - konfiguracja", driver.getTitle());
	}

	@Test
	Public void testWindowUsingContents() {}
		// Zapamiętanie uchwytu WindowHandle nadrzędnego okna przeglądarki
		String currentWindowId = driver.getWindowHandle();

		// Kliknięcie przycisku Rozmowa spowoduje otwarcie strony czatu w nowym oknie potomnym
		driver.findElement(By.id("chatbutton")).click();

		// Dla strony czatu nie wprowadzono nazwy, ani tytułu
		// Aby znaleźć okno czatu, będziemy iterować po wszystkich otwartych oknach
		// i sprawdzać ich zawartość.
		try {
			for (String windowId : driver.getWindowHandles()) {
				driver.switchTo().window(windowId);

				// Do sprawdzenia zawartości użyjemy źródła strony
				String pageSource = driver.getPageSource();

				If (pageSource.contains ("Konfiguracja - czat Online")) {

					// Znajdź na stronie element wyświetlający oczekiwany
					// komunikat
					assertTrue(driver.findElement(By.tagName("p")).getText()
							.equals("Czekaj na połączenie z czatem..."));

					// Znajdź przycisk Zamknij w oknie czatu i zamknij okno
					// klikając przycisk Zamknij
					driver.findElement(By.id("closebutton")).click();
					break;
				}
			}
		} finally {
			// Przełączenie się do nadrzędnego okna przeglądarki
			driver.switchTo().window(currentWindowId);
		}
		// Sprawdzenie, czy kontekstem sterownika jest nadrzędne okno przeglądarki
		assertEquals("Zbuduj swój samochód - konfiguracja", driver.getTitle());
	}

	@AfterClass
	public static void tearDown() {
		driver.quit();
	}
}

