package com.secookbook.examples.chapter01;

import static org.junit.Assert.*;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.edge.EdgeDriver;
import org.openqa.selenium.edge.EdgeOptions;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.WebDriverWait;

public class GoogleSearchTestOnEdge {

	private WebDriver driver;

	@Before
	public void setUp() {
		System.setProperty("webdriver.edge.driver",
				"C:\\Program Files (x86)\\Microsoft Web Driver\\MicrosoftWebDriver.exe");

		EdgeOptions options = new EdgeOptions();
		options.setPageLoadStrategy("eager");

		// Uruchom nowy egzemplarz Edge
		driver = new EdgeDriver(options);

		//Przejdź do Google
		driver.get("http://www.google.com");
	}

	@Test
	public void testGoogleSearch() {
		// Znajdź element wprowadzania tekstu na podstawie jego nazwy
		WebElement element = driver.findElement(By.name("q"));

		// Wyczyść teskst zapisany w elemencie
		element.clear();

		// Wpisz informacje do wyszukania
		element.sendKeys("Testowanie z Selenium. Receptury");

		WebElement button = driver.findElement(By.name("btnG"));
		button.click();

		// Strona wyszukiwania w Google jest dynamicznie renderowana za pomocą JavaScript.
		// Czekamy na załadowanie się strony. Timeout po 10 sekundach.
		new WebDriverWait(driver, 10).until(new ExpectedCondition<Boolean>() {
			public Boolean apply(WebDriver d) {
				return d.getTitle().toLowerCase()
						.startsWith("testowanie z selenium. receptury");
			}
		});

		assertEquals("Testowanie z Selenium. Receptury - Szukaj z Google",
				driver.getTitle());
	}

	@After
	public void tearDown() throws Exception {
		// Zamknij przeglądarkę
		driver.quit();
	}

}

