package pack;

/*################################################################# #####################################
 'Project Name		: Open2Test framework for Selenium Web Driver
 'Author		       	: Open2Test
 'Version	    	: V 1.2
 'Date of Creation	: 13-Aug-2013
 '#######################################################################################################
 */
import static org.junit.Assert.fail;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;

import jxl.Sheet;
import jxl.Workbook;
import jxl.WorkbookSettings;
import jxl.read.biff.BiffException;

import org.apache.commons.io.FileUtils;
import org.junit.After;
import org.junit.Test;
import org.openqa.selenium.By;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.UnhandledAlertException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.ie.InternetExplorerDriver;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.support.ui.Select;

public class Open2Test {

	static BufferedWriter bw = null;
	static BufferedWriter bw1 = null;
	static WebDriver D8;
	Date cur_dt = null;
	String TestSuite;
	String TestScript;
	String ObjectRepository;
	int startrow = 0;
	static String ReportsPath;
	String strResultPath;
	String[] TCNm = null;
	static String exeStatus = "True";
	static String TestReport;
	static int rowcnt;
	static int dtrownum = 1;
	static int ORrowcount = 0;
	// int loopcount = 0;
	static String ORvalname = "";
	static String ORvalue = "";
	static String Action = "";
	static String cCellData = "";
	static String dCellData = "";
	static String htmlname = "";
	String[] cCellDataVal = null;
	String[] dCellDataVal = null;
	String ObjectSet;
	String ObjectSetVal = "";
	static Sheet DTsheet = null;
	static Sheet ORsheet;
	String Searchtext;
	static int iflag = 0;
	static int screenshotflag = 0;
	static int loopflag = 0;
	static int j = 0;
	static int loopsize = -1;
	int[] loopstart = new int[1];
	int[] loopcount = new int[1];
	int[] loopend = new int[1];
	static int[] loopcnt = new int[1];
	static int[] dtrownumloop = new int[1];
	boolean captureperform = false;
	static boolean capturecheckvalue = false;
	static boolean capturestorevalue = false;
	static Sheet TScsheet;
	static Workbook TScworkbook;
	static int TScrowcount = 0;
	static int loopnum = 1;
	static String TScname;
	static String ActionVal;
	String BrowserType = "FF"; // Assign with either FF or IE
	static int DTcolumncount = 0;
	static WebElement elem = null;
	private static Map<String, String> map = new HashMap<String, String>();
	private static Map<String, Float> mapint = new HashMap<String, Float>();

	/*
	 * This function reads the selenium utility file and identifies where Object
	 * Repository, Test Suite & Test Scripts are located
	 */

	@Test
	public void ReadUtilFile() throws Exception {
		for (int z = 0; z < 1; z++) {
			loopstart[z] = 0;
			loopend[z] = 0;
			loopcnt[z] = 0;
			dtrownumloop[z] = 1;
			loopcount[z] = 0;
		}
		switch (BrowserType.toUpperCase()) {
		case "IE":
			System.setProperty("webdriver.ie.driver", "C:/IEDriverServer.exe");
			DesiredCapabilities capability = DesiredCapabilities
					.internetExplorer();
			capability
					.setCapability(
							InternetExplorerDriver.INTRODUCE_FLAKINESS_BY_IGNORING_SECURITY_DOMAINS,
							true);
			capability.setCapability("useLegacyInternalServer", true);
			D8 = new InternetExplorerDriver(capability);
			D8.getWindowHandle();
			D8.manage().timeouts().implicitlyWait(30, TimeUnit.SECONDS);
			D8.manage().window().maximize();
			break;
		case "FF":
			D8 = new FirefoxDriver();
			D8.manage().timeouts().implicitlyWait(30, TimeUnit.SECONDS);
			D8.manage().window().maximize();
			break;
		default:
			System.out.println("Error : Invalid browser type");
		}
		{
			PrintWriter pw = new PrintWriter(new FileWriter(
					"C://Users/Sams/workspacekepler/Open2Test/Excel/test.html"));
			pw.println("<TABLE BORDER><TR><TH>Execute<TH>Keyword<TH>Object<TH>Action<Result></TR>");

			Workbook w1 = null;
			try {
				w1 = Workbook
						.getWorkbook(new File(
								"C:\\Users\\Sams\\workspacekepler\\Open2Test\\Excel\\Selenium_Utility.xls"));
			} catch (BiffException e) { // TODO Auto-generated catch block
				e.printStackTrace();
			} catch (IOException e) { // TODO Auto-generated catch block
				e.printStackTrace();
			}
			Sheet sheet = w1.getSheet(0);
			TestSuite = sheet.getCell(1, 1).getContents();
			TestScript = sheet.getCell(1, 2).getContents();
			ObjectRepository = sheet.getCell(1, 3).getContents();
			ReportsPath = sheet.getCell(1, 5).getContents();
			TestReport = sheet.getCell(1, 6).getContents();
			FindExecTestscript(TestSuite, TestScript, ObjectRepository);
		}
	}

	public void FindExecTestscript(String TestSuite, String TestScript,
			String ObjectRepository) throws Exception {
		try {
			int TSrowcount = 0;
			FileInputStream fs = null;
			WorkbookSettings ws = null;
			fs = new FileInputStream(new File(TestSuite));
			ws = new WorkbookSettings();
			ws.setLocale(new Locale("en", "EN"));
			Workbook TSworkbook = Workbook.getWorkbook(fs, ws);
			Sheet TSsheet = TSworkbook.getSheet(0);
			TSrowcount = TSsheet.getRows();
			cur_dt = new Date();
			DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss");
			String strTimeStamp = dateFormat.format(cur_dt);
			String rp = ReportsPath;
			if (rp == "") { // if results path is passed as null, by
				// default 'C:\' drive is used
				rp = "C:\\";
			}

			if (rp.endsWith("\\")) { // checks whether the path ends with
				// '/'
				rp = rp + "\\";
			}
			// TCNm = scriptName.split("\\.");
			strResultPath = rp + "Log" + "/";
			String htmlname1 = rp + "Log" + "/Test_Suite_" + strTimeStamp
					+ ".html";
			File f = new File(strResultPath);
			f.mkdirs();
			bw1 = new BufferedWriter(new FileWriter(htmlname1));
			bw1.write("<HTML><BODY><TABLE BORDER=0 CELLPADDING=3 CELLSPACING=1 WIDTH=100%>");
			bw1.write("<TABLE BORDER=0 BGCOLOR=BLACK CELLPADDING=3 CELLSPACING=1 WIDTH=100%>");
			bw1.write("<TR><TD COLSPAN=6 BGCOLOR=#66699><FONT FACE=VERDANA COLOR=WHITE SIZE=2><B>Testcase Name</B></FONT></TD><TD BGCOLOR=#66699 WIDTH=27%><FONT FACE=VERDANA COLOR=WHITE SIZE=2><B>Status</B></FONT></TD></TR>");
			for (int i = 0; i < TSsheet.getRows(); i++) {
				String TSvalidate = "r";
				if (((TSsheet.getCell(0, i).getContents())
						.equalsIgnoreCase(TSvalidate) == true)) {
					// String TCStatus = "Pass";
					String ScriptName = TSsheet.getCell(1, i).getContents();
					ExecKeywordScript(ScriptName, TestScript, ObjectRepository);
					if (exeStatus.equalsIgnoreCase("Failed")) {
						bw1.write("<TR><TD COLSPAN=6 BGCOLOR=WHITE><FONT FACE=VERDANA COLOR=BLACK SIZE=2><B>"
								+ TCNm[0]
								+ "</B></FONT></TD><TD BGCOLOR=WHITE WIDTH=27%><FONT FACE=VERDANA COLOR=RED SIZE=2><B>"
								+ exeStatus + "</B></FONT></TD></TR>");
					} else {
						bw1.write("<TR><TD COLSPAN=6 BGCOLOR=WHITE><FONT FACE=VERDANA COLOR=BLACK SIZE=2><B>"
								+ TCNm[0]
								+ "</B></FONT></TD><TD BGCOLOR=WHITE WIDTH=27%><FONT FACE=VERDANA COLOR=GREEN SIZE=2><B>"
								+ exeStatus + "</B></FONT></TD></TR>");
					}
				}
				/*
				 * else { System.out.println(TSvalidate); }
				 */
			}
			bw1.close();
		} catch (Exception e) {
			bw.close();
			bw1.close();
		}
	}

	public void ExecKeywordScript(String scriptName, String TestScript,
			String ObjectRepository) throws Exception {

		// Report header
		cur_dt = new Date();
		DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss");
		String strTimeStamp = dateFormat.format(cur_dt);

		if (ReportsPath == "") { // if results path is passed as null, by
									// default 'C:\' drive is used
			ReportsPath = "C:\\";
		}

		if (ReportsPath.endsWith("\\")) { // checks whether the path ends with
											// '/'
			ReportsPath = ReportsPath + "\\";
		}
		TCNm = scriptName.split("\\.");
		strResultPath = ReportsPath + "Log" + "/" + TCNm[0] + "/";
		String htmlname = ReportsPath + "Log" + "/" + TCNm[0] + "/"
				+ strTimeStamp + ".html";
		File f = new File(strResultPath);
		f.mkdirs();
		bw = new BufferedWriter(new FileWriter(htmlname));
		bw.write("<HTML><BODY><TABLE BORDER=0 CELLPADDING=3 CELLSPACING=1 WIDTH=100%>");
		bw.write("<TABLE BORDER=0 BGCOLOR=BLACK CELLPADDING=3 CELLSPACING=1 WIDTH=100%>");
		bw.write("<TR><TD BGCOLOR=#66699 WIDTH=27%><FONT FACE=VERDANA COLOR=WHITE SIZE=2><B>Test Case Name:</B></FONT></TD><TD COLSPAN=6 BGCOLOR=#66699><FONT FACE=VERDANA COLOR=WHITE SIZE=2><B>"
				+ TCNm[0] + "</B></FONT></TD></TR>");
		bw.write("<HTML><BODY><TABLE BORDER=1 CELLPADDING=3 CELLSPACING=1 WIDTH=100%>");
		bw.write("<TR COLS=6><TD BGCOLOR=#FFCC99 WIDTH=3%><FONT FACE=VERDANA COLOR=BLACK SIZE=2><B>Row</B></FONT></TD><TD BGCOLOR=#FFCC99 WIDTH=15%><FONT FACE=VERDANA COLOR=BLACK SIZE=2><B>Keyword</B></FONT></TD><TD BGCOLOR=#FFCC99 WIDTH=25%><FONT FACE=VERDANA COLOR=BLACK SIZE=2><B>Object</B></FONT></TD><TD BGCOLOR=#FFCC99 WIDTH=25%><FONT FACE=VERDANA COLOR=BLACK SIZE=2><B>Action</B></FONT></TD><TD BGCOLOR=#FFCC99 WIDTH=25%><FONT FACE=VERDANA COLOR=BLACK SIZE=2><B>Execution Time</B></FONT></TD><TD BGCOLOR=#FFCC99 WIDTH=25%><FONT FACE=VERDANA COLOR=BLACK SIZE=2><B>Status</B></FONT></TD></TR>");

		exeStatus = "Pass";
		String scriptPath = TestScript + scriptName;
		TScname = scriptName;
		FileInputStream fs1 = null;
		WorkbookSettings ws1 = null;
		fs1 = new FileInputStream(new File(scriptPath));
		ws1 = new WorkbookSettings();
		ws1.setLocale(new Locale("en", "EN"));
		Workbook TScworkbook = Workbook.getWorkbook(fs1, ws1);
		Sheet TScsheet = TScworkbook.getSheet(0);
		TScrowcount = TScsheet.getRows();
		// *This is the Data Table Sheet
		rowcnt = 0;
		// System.out.println("Row count : " + TScrowcount);
		for (j = 0; j < TScrowcount; j++) {
			// Thread.sleep(1000);
			// System.out.println("J : " + j);
			rowcnt = rowcnt + 1;
			String TSvalidate = "r";
			if (((TScsheet.getCell(0, j).getContents())
					.equalsIgnoreCase(TSvalidate) == true)) {
				Action = TScsheet.getCell(1, j).getContents();
				cCellData = TScsheet.getCell(2, j).getContents();
				dCellData = TScsheet.getCell(3, j).getContents();
				String ORPath = ObjectRepository;
				FileInputStream fs2 = null;
				WorkbookSettings ws2 = null;
				try {
					fs2 = new FileInputStream(new File(ORPath));
					ws2 = new WorkbookSettings();
					ws2.setLocale(new Locale("en", "EN"));
				} catch (Exception e) {
					System.out.println("File not found");
				}
				try {
					Workbook ORworkbook = Workbook.getWorkbook(fs2, ws2);
					ORsheet = ORworkbook.getSheet(0);
					ORrowcount = ORsheet.getRows();
					ActionVal = Action.toLowerCase();
					iflag = 0;

				} catch (Exception e) {
					// System.out.println(e);
					fail("Excel file of Open2Test is not correct.");
				}
				bcellAction(scriptName);
			}// End of Execution

		}// End of If that get all rows in Test Script
		bw.close();
	}// End of For that get all rows in Test Script

	public static void screenshot(int loopn, int rown, String Sname)
			throws Exception {
		try {
			screenshotflag = screenshotflag + 1;
			DateFormat dateFormat = new SimpleDateFormat("yyyyMMdd-HH-mm-ss");
			Date date = new Date();
			String filenamer = "";
			String strTime = dateFormat.format(date);
			Sname = Sname.substring(0, Sname.indexOf("."));
			File screenshot = ((TakesScreenshot) D8)
					.getScreenshotAs(OutputType.FILE);
			TestReport = TestReport.toLowerCase();
			if (TestReport == "")
				TestReport = ReportsPath;
			if (!(TestReport.contains("screen")))
				TestReport = TestReport + "Screenshot/";
			if (loopflag == 0) {
				filenamer = TestReport + Sname + "/" + Sname + "_"
						+ screenshotflag + "_rowno_" + (j + 1) + "_" + strTime
						+ ".png";
			} else {
				filenamer = TestReport + Sname + "/" + Sname + "_"
						+ screenshotflag + "_loop_" + (loopcnt[loopsize] + 1)
						+ "_rowno_" + (j + 1) + "_" + strTime + ".png";
			}
			FileUtils.copyFile(screenshot, new File(filenamer));
		} catch (Exception e) {
			System.out.println(e);
		}
	}

	public static void Update_Report(String Res_type) throws IOException {
		String str_time;
		String[] str_rep = new String[2];
		Date exec_time = new Date();
		DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss");
		str_time = dateFormat.format(exec_time);
		if (Res_type.startsWith("executed")) {
			bw.write("<TR COLS=6><TD BGCOLOR=#EEEEEE WIDTH=5%><FONT FACE=VERDANA SIZE=2>"
					+ (j + 1)
					+ "</FONT></TD><TD BGCOLOR=#EEEEEE WIDTH=17%><FONT FACE=VERDANA SIZE=2>"
					+ Action
					+ "</FONT></TD><TD BGCOLOR=#EEEEEE WIDTH=30%><FONT FACE=VERDANA SIZE=2>"
					+ cCellData
					+ "</FONT></TD></TD><TD BGCOLOR=#EEEEEE WIDTH=30%><FONT FACE=VERDANA SIZE=2>"
					+ dCellData
					+ "</FONT></TD><TD BGCOLOR=#EEEEEE WIDTH=30%><FONT FACE=VERDANA SIZE=2>"
					+ str_time
					+ "</FONT></TD><TD BGCOLOR=#EEEEEE WIDTH=30%><FONT FACE=VERDANA SIZE=2 COLOR = GREEN>"
					+ "Passed" + "</FONT></TD></TR>");
		} else if (Res_type.startsWith("failed")) {
			exeStatus = "Failed";
			bw.write("<TR COLS=6><TD BGCOLOR=#EEEEEE WIDTH=5%><FONT FACE=VERDANA SIZE=2>"
					+ (j + 1)
					+ "</FONT></TD><TD BGCOLOR=#EEEEEE WIDTH=17%><FONT FACE=VERDANA SIZE=2>"
					+ Action
					+ "</FONT></TD><TD BGCOLOR=#EEEEEE WIDTH=30%><FONT FACE=VERDANA SIZE=2>"
					+ cCellData
					+ "</FONT></TD></TD><TD BGCOLOR=#EEEEEE WIDTH=30%><FONT FACE=VERDANA SIZE=2>"
					+ dCellData
					+ "</FONT></TD><TD BGCOLOR=#EEEEEE WIDTH=30%><FONT FACE=VERDANA SIZE=2>"
					+ str_time
					+ "</FONT></TD><TD BGCOLOR=#EEEEEE WIDTH=30%><FONT FACE=VERDANA SIZE=2 COLOR = RED>"
					+ "Failed" + "</FONT></TD></TR>");
		} else if (Res_type.startsWith("loop")) {
			bw.write("<TR COLS=6><th colspan= 6 BGCOLOR=#EEEEEE WIDTH=5%><FONT FACE='WINGDINGS 2' SIZE=3 COLOR=BLUE><div align=left></FONT><FONT FACE=VERDANA SIZE=2 COLOR = BLUE>"
					+ Res_type + "</div></th></FONT></TR>");
		} else if (Res_type.startsWith("missing")) {
			exeStatus = "Failed";
			bw.write("<TR COLS=6><TD BGCOLOR=#EEEEEE WIDTH=5%><FONT FACE=VERDANA SIZE=2>"
					+ (j + 1)
					+ "</FONT></TD><TD BGCOLOR=#EEEEEE WIDTH=17%><FONT FACE=VERDANA SIZE=2>"
					+ Action
					+ "</FONT></TD><TD BGCOLOR=#EEEEEE WIDTH=30%><FONT FACE=VERDANA SIZE=2>"
					+ cCellData
					+ "</FONT></TD></TD><TD BGCOLOR=#EEEEEE WIDTH=30%><FONT FACE=VERDANA SIZE=2>"
					+ dCellData
					+ "</FONT></TD><TD BGCOLOR=#EEEEEE WIDTH=30%><FONT FACE=VERDANA SIZE=2>"
					+ str_time
					+ "</FONT></TD><TD BGCOLOR=#EEEEEE WIDTH=30%><FONT FACE=VERDANA SIZE=2 COLOR = ORANGE>"
					+ "Failed" + "</FONT></TD></TR>");
			bw.write("<TR COLS=6><th colspan= 6 BGCOLOR=#EEEEEE WIDTH=5%><FONT FACE='WINGDINGS 2' SIZE=3 COLOR=RED><div align=left>X </FONT><FONT FACE=VERDANA SIZE=2 COLOR = RED>Error Occurred in Keyword test step number "
					+ (j + 1)
					+ ".Description: The Datatable column name not found</div></th></FONT></TR>");
		} else if (Res_type.startsWith("ObjectLocator")) {
			bw.write("<TR COLS=6><TD BGCOLOR=#EEEEEE WIDTH=5%><FONT FACE=VERDANA SIZE=2>"
					+ (j + 1)
					+ "</FONT></TD><TD BGCOLOR=#EEEEEE WIDTH=17%><FONT FACE=VERDANA SIZE=2>"
					+ Action
					+ "</FONT></TD><TD BGCOLOR=#EEEEEE WIDTH=30%><FONT FACE=VERDANA SIZE=2>"
					+ cCellData
					+ "</FONT></TD></TD><TD BGCOLOR=#EEEEEE WIDTH=30%><FONT FACE=VERDANA SIZE=2>"
					+ dCellData
					+ "</FONT></TD><TD BGCOLOR=#EEEEEE WIDTH=30%><FONT FACE=VERDANA SIZE=2>"
					+ str_time
					+ "</FONT></TD><TD BGCOLOR=#EEEEEE WIDTH=30%><FONT FACE=VERDANA SIZE=2 COLOR = ORANGE>"
					+ "Failed" + "</FONT></TD></TR>");
			bw.write("<TR COLS=6><th colspan= 6 BGCOLOR=#EEEEEE WIDTH=5%><FONT FACE='WINGDINGS 2' SIZE=3 COLOR=RED><div align=left>X </FONT><FONT FACE=VERDANA SIZE=2 COLOR = RED>Error Occurred in Keyword test step number "
					+ (j + 1)
					+ ".Description: Object Locator is wrong or not supported. Supported Locators are Id,Name,Xpath& CSS</div></th></FONT></TR>");
		}
	}

	public static void Update_Report(String Res_type, Exception e)
			throws IOException {
		String str_time;
		Date exec_time = new Date();
		DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss");
		str_time = dateFormat.format(exec_time);
		exeStatus = "Failed";
		if (Res_type.startsWith("failed")) {
			bw.write("<TR COLS=6><TD BGCOLOR=#EEEEEE WIDTH=5%><FONT FACE=VERDANA SIZE=2>"
					+ (j + 1)
					+ "</FONT></TD><TD BGCOLOR=#EEEEEE WIDTH=17%><FONT FACE=VERDANA SIZE=2>"
					+ Action
					+ "</FONT></TD><TD BGCOLOR=#EEEEEE WIDTH=30%><FONT FACE=VERDANA SIZE=2>"
					+ cCellData
					+ "</FONT></TD></TD><TD BGCOLOR=#EEEEEE WIDTH=30%><FONT FACE=VERDANA SIZE=2>"
					+ dCellData
					+ "</FONT></TD><TD BGCOLOR=#EEEEEE WIDTH=30%><FONT FACE=VERDANA SIZE=2>"
					+ str_time
					+ "</FONT></TD><TD BGCOLOR=#EEEEEE WIDTH=30%><FONT FACE=VERDANA SIZE=2 COLOR = RED>"
					+ "Failed" + "</FONT></TD></TR>");
			bw.write("<TR COLS=6><th colspan= 6 BGCOLOR=#EEEEEE WIDTH=5%><FONT FACE='WINGDINGS 2' SIZE=3 COLOR=RED><div align=left></FONT><FONT FACE=VERDANA SIZE=2 COLOR = RED>"
					+ e.toString().substring(
							e.toString().indexOf(":") + 1,
							e.toString().indexOf(".",
									e.toString().indexOf(":") + 1) + 1)
					+ "</div></th></FONT></TR>");
		}
	}

	private static void Func_StoreCheck() throws Exception {
		// TODO Auto-generated method stub
		try {
			String actval = null;
			String expval;
			Boolean boolval = null;
			String varname;
			String[] cCellDataValCh = cCellData.split(";");
			String ObjectValCh = cCellDataValCh[1];
			String[] dCellDataValCh = dCellData.split(":");
			String ObjectSetCh = dCellDataValCh[0];
			String ObjectSetValCh = "";
			int DTcolumncountCh = 0;
			// DTcolumncountCh = DTsheet.getColumns();
			if (dCellDataValCh.length == 2) {
				ObjectSetValCh = dCellDataValCh[1];
			}
			for (int k = 0; k < ORrowcount; k++) {
				String ORName = ORsheet.getCell(0, k).getContents();

				if (((ORsheet.getCell(0, k).getContents())
						.equalsIgnoreCase(ObjectValCh) == true)) {
					String[] ORcellData = new String[3];
					ORcellData = (ORsheet.getCell(3, k).getContents())
							.split("=");
					ORvalname = ORcellData[0];
					ORvalue = ORcellData[1];
					k = ORrowcount + 1;
				}
			}
			if (ObjectSetValCh.contains("dt_")) {
				String ObjectSetValtableheader[] = ObjectSetValCh.split("_");
				int column = 0;
				String Searchtext = ObjectSetValtableheader[1];

				for (column = 0; column < DTcolumncount; column++) {
					if (Searchtext.equalsIgnoreCase(DTsheet.getCell(column, 0)
							.getContents()) == true) {
						ObjectSetValCh = DTsheet.getCell(column, dtrownum)
								.getContents();
						iflag = 1;
					}
				}
				if (iflag == 0) {
					ORvalname = "exit";
				}
			}
			switch (ObjectSetCh.toLowerCase()) {
			case "enabled":
				Func_FindObj(ORvalname, ORvalue);
				boolval = elem.isEnabled();
				actval = boolval.toString();
				break;
			case "text":
				Func_FindObj(ORvalname, ORvalue);
				actval = elem.getAttribute("value");
				break;
			case "value":
				Func_FindObj(ORvalname, ORvalue);
				actval = new Select(elem).getFirstSelectedOption().getText()
						.toString();
				break;
			case "visible":
				Func_FindObj(ORvalname, ORvalue);
				boolval = elem.isDisplayed();
				actval = boolval.toString();
				break;
			case "checked":
				Func_FindObj(ORvalname, ORvalue);
				boolval = elem.isSelected();
				actval = boolval.toString();
				break;
			case "linktext":
				Func_FindObj(ORvalname, ORvalue);
				actval = elem.getText();
				break;
			default:
				actval = "Invalid syntax";
				break;
			}

			if ((ActionVal).equalsIgnoreCase("check")) {
				expval = ObjectSetValCh;
				if (expval.equalsIgnoreCase("On"))
					expval = "True";
				else if (expval.equalsIgnoreCase("Off"))
					expval = "False";
				if (expval.equalsIgnoreCase(actval)) {
					System.out
							.println("Actual value matches with expected value. Actual value is "
									+ actval);
					Update_Report("executed");
				} else {
					System.out
							.println("Actual value doesn't match with expected value. Actual value is "
									+ actval);
					if (ORvalname == "exit") {
						Update_Report("missing");
					} else {
						Update_Report("failed");
					}
					if (capturecheckvalue == true) {
						screenshot(loopnum, TScrowcount, TScname);
					}
				}
			} else if ((ActionVal).equalsIgnoreCase("storevalue")) {
				System.out.println(actval);
				varname = ObjectSetValCh;
				if (actval.equalsIgnoreCase("Invalid syntax")) {
					Update_Report("missing");
				} else {
					if (map.containsKey(varname)) {
						map.put(varname, actval);
						Update_Report("executed");
						System.out
								.println("Overwriting the value of the variable "
										+ varname
										+ " to store the value as mentioned in the test case row number"
										+ rowcnt);
						map.remove(varname);
					} else {
						map.put(varname, actval);
						Update_Report("executed");
						System.out
								.println("Overwriting the value of the variable "
										+ varname
										+ " to store the value as mentioned in the test case row number"
										+ rowcnt);
						if (ORvalname == "exit") {
							Update_Report("missing");
						} else {
						}
					}
				}
				if (capturestorevalue == true) {
					screenshot(loopnum, TScrowcount, TScname);
				}
			}
		} catch (Exception e) {
			// Update_Report("failed", e);
			// bw.close();
		}
	}

	@After
	public void close() throws Exception {
		try {
			System.out.println("Test end.");
			D8.quit();
		} catch (UnhandledAlertException e) {
			System.out.println(e);
			System.out
					.println("Because of specification of SeleniumWebDriver, downloading may be failed.");
			System.out
					.println("Please confirm the report file and screenshot about test result.");
		}
	}

	private static void Func_FindObj(String strObjtype, String strObjpath)
			throws Exception {
		try {
			if (strObjtype.length() > 0 && strObjpath.length() > 0) {
				if (strObjtype.equalsIgnoreCase("id")) {
					elem = D8.findElement(By.id(strObjpath));
				} else if (strObjtype.equalsIgnoreCase("name")) {
					elem = D8.findElement(By.name(strObjpath));
				} else if (strObjtype.equalsIgnoreCase("xpath")) {
					elem = D8.findElement(By.xpath(strObjpath));
				} else if (strObjtype.equalsIgnoreCase("link")) {
					elem = D8.findElement(By.linkText(strObjpath.toString()));
				} else if (strObjtype.equalsIgnoreCase("css")) {
					elem = D8.findElement(By.cssSelector(strObjpath));
				}
			}
		} catch (Exception e) {
			Update_Report("failed", e);
			// System.out.println(e.toString());
			elem = null;
		}
	}

	public static int ifContidionSkipper(String strifConditionStatus)
			throws Exception {
		try {

			String strKeyword;
			int intLogicStartRow, intLogicEndRow, intIfEndConditionCount, intIfConditionCount;
			String strKeyWord;
			intIfConditionCount = 1;
			intIfEndConditionCount = 0;
			if (strifConditionStatus.equalsIgnoreCase("false")) {
				intLogicStartRow = j;
				do {
					j = j + 1;
					strKeyword = TScsheet.getCell(1, j).getContents();
					System.out.println(strKeyword);
					if (strKeyword.equalsIgnoreCase("Condition")) {
						intIfConditionCount = intIfConditionCount + 1;
					}
					if (strKeyword.equalsIgnoreCase("Endcondition")) {
						intIfEndConditionCount = intIfEndConditionCount + 1;
						if (intIfConditionCount == intIfEndConditionCount) {
							j = j + 1;
							break;
						}
					}

				} while (true);
			}
		} catch (Exception e) {

		}
		return j;
	}

	public String Func_IfCondition(String strConditionArgs) throws Exception {
		int iFlag = 1;
		String str[] = strConditionArgs.split(";");
		String value1 = str[0];
		String value2 = str[2];
		String strOperation = str[1];
		strOperation = strOperation.toLowerCase().trim();

		switch (strOperation.toLowerCase()) {
		case "equals":
			if (value1.substring(0, 1).equalsIgnoreCase("#")) {
				value1 = map.get(value1.substring(1, (value1.length())));
				System.out
						.println("Variable used in condition statement has value: "
								+ value1);
				if (value1.trim().equalsIgnoreCase(value2.trim())) {
					iFlag = 0;
				}
			} else if (value1.trim().equalsIgnoreCase(value2.trim())) {
				iFlag = 0;
			}
			break;

		case "notequals":
			if (value1.substring(0, 1).equalsIgnoreCase("#")) {
				value1 = map.get(value1.substring(1, (value1.length())));
				System.out
						.println("Variable used in condition statement has values: "
								+ value1);
				if (value1.trim().equalsIgnoreCase(value2.trim())) {
					iFlag = 0;
				}
			} else if (!value1.trim().equals(value2.trim())) {
				iFlag = 0;
			}
			break;

		case "greaterthan":
			if (isInteger(value1) && isInteger(value2)) {
				if (Integer.parseInt(value1) > Integer.parseInt(value2)) {
					iFlag = 0;
				}
			} else {
				// Report
			}
			break;
		case "lessthan":
			if (isInteger(value1) && isInteger(value2)) {
				if (Integer.parseInt(value1) < Integer.parseInt(value2)) {
					iFlag = 0;
				}
			} else {
				// Report
			}
			break;
		default:
			Update_Report("missing");

		}
		if (iFlag == 0) {
			return "true";
		} else {
			return "false";
		}

	}

	public void arrayresize() {
		if (loopstart.length <= loopsize) {
			loopstart = Arrays.copyOf(loopstart, loopstart.length + 1);
			loopend = Arrays.copyOf(loopend, loopend.length + 1);
			loopcnt = Arrays.copyOf(loopcnt, loopcnt.length + 1);
			dtrownumloop = Arrays.copyOf(dtrownumloop, dtrownumloop.length + 1);
			loopcount = Arrays.copyOf(loopcount, loopcount.length + 1);
		}
	}

	public void bcellAction(String scriptName) throws Exception {
		try {
			switch (ActionVal.toLowerCase()) {

			case "loop":
				startrow = j;
				dtrownum = 1;
				loopsize = loopsize + 1;
				if (loopsize >= 1) {
					arrayresize();
				}
				loopflag = 1;
				loopcount[loopsize] = Integer.parseInt(cCellData);
				loopstart[loopsize] = j;
				loopcnt[loopsize] = 0;
				dtrownumloop[loopsize] = dtrownum;
				Update_Report("loop : " + "Start of loop : " + (loopsize + 1));
				Update_Report("executed");
				break;
			case "endloop":
				loopcnt[loopsize] = loopcnt[loopsize] + 1;
				loopnum = loopnum + 1;
				if (loopcnt[loopsize] == loopcount[loopsize]) {
					Update_Report("loop" + " End of Loop : " + (loopsize + 1)
							+ " : Loop count : " + loopcnt[loopsize]);
					loopsize = loopsize - 1;
					if (loopsize >= 0)
						dtrownum = dtrownumloop[loopsize];
					else {
						dtrownum = 1;
						loopflag = 0;
					}
					Update_Report("executed");
				} else {
					j = loopstart[loopsize];
					dtrownum = dtrownum + 1;
					dtrownumloop[loopsize] = dtrownum;
					Update_Report("loop" + " End of Loop : " + (loopsize + 1)
							+ " : Loop count : " + loopcnt[loopsize]);
				}
				rowcnt = 1;
				break;
			case "launchapp":
				D8.get(cCellData);
				Update_Report("executed");
				break;

			case "wait":
				Thread.sleep(Long.parseLong(cCellData));
				Update_Report("executed");
				break;

			case "condition":
				String strConditionStatus = Func_IfCondition(cCellData);
				if (strConditionStatus.equalsIgnoreCase("false")) {
					j = ifContidionSkipper(strConditionStatus);
					j = j + 1;
					System.out.println(j);
				}
				Update_Report("executed");
				break;

			case "endcondition":
				Update_Report("executed");
				break;

			case "screencaptureoption":
				String[] sco = cCellData.split(";");

				for (int s = 0; s < sco.length; s++) {
					if (sco[s].equalsIgnoreCase("perform")) {
						captureperform = true;
					}
					if (sco[s].equalsIgnoreCase("storevalue")) {
						capturestorevalue = true;
					}
					if (sco[s].equalsIgnoreCase("check")) {
						capturecheckvalue = true;
					}

				}
				Update_Report("executed");
				break;
			case "importdata":
				// Runtime rt = Runtime.getRuntime();
				// Process p = rt.exec("D://AutoITScript/FileDown.exe");
				String xcelpath = cCellData;
				FileInputStream fs3 = null;
				WorkbookSettings ws3 = null;
				fs3 = new FileInputStream(new File(xcelpath));
				ws3 = new WorkbookSettings();
				ws3.setLocale(new Locale("en", "EN"));
				Workbook DTworkbook = Workbook.getWorkbook(fs3, ws3);
				DTsheet = DTworkbook.getSheet(0);
				int DTrowcount = DTsheet.getRows();
				String DTName;
				Update_Report("executed");
				break;

			case "screencapture":
				screenshot(loopnum, TScrowcount, TScname);
				Update_Report("executed");
				break;
			case "check":
				Func_StoreCheck();
				break;
			case "storevalue":
				Func_StoreCheck();
				break;

			case "perform":
				cCellDataVal = cCellData.split(";");
				dCellDataVal = null;
				String ObjectVal = cCellData.substring(
						cCellDataVal[0].length() + 1, cCellData.length());
				dCellData.toString();
				if (dCellData.contains(":")) {
					dCellDataVal = dCellData.split(":");
					ObjectSet = dCellDataVal[0].toLowerCase();
					ObjectSetVal = dCellDataVal[1];
				} else {
					ObjectSet = dCellData.toString();
				}
				DTcolumncount = 0;
				if (ObjectSetVal.contains("dt_"))
					DTcolumncount = DTsheet.getColumns();
				for (int k = 0; k < ORrowcount; k++) {
					String ORName = ORsheet.getCell(0, k).getContents();

					if (((ORsheet.getCell(0, k).getContents())
							.equalsIgnoreCase(ObjectVal) == true)) {
						String[] ORcellData = new String[3];
						ORcellData = (ORsheet.getCell(3, k).getContents())
								.split("=");
						ORvalname = ORcellData[0];
						ORvalue = ORsheet.getCell(3, k).getContents()
								.substring(ORcellData[0].length() + 1);
						k = ORrowcount + 1;
					}
				}
				dCellAction();
				// End of Objectset Switch
				// Update_Report("executed");
			}// End of Actval Switch
		} /*
		 * catch (UnhandledAlertException e) {
		 * 
		 * for (String id : D8.getWindowHandles()) {
		 * System.out.println("WindowHandle: " + D8.switchTo().window(id));
		 * 
		 * } System.out.println(e); System.out .println(
		 * "Because of specification of SeleniumWebDriver, downloading may be failed."
		 * ); System.out .println(
		 * "Please confirm the report file and screenshot about test result.");
		 * }
		 */catch (Exception ex) {
			Update_Report("failed", ex);
			System.out.println(ex);
			System.out.println("------Error Information : Open2Test-------");
			System.out.println("Current Script:" + scriptName);
			System.out.println("Current ScriptPath:" + TestScript);
			System.out
					.println("Using ObjectRepositoryPath:" + ObjectRepository);
			System.out.println("Current Keyword:" + Action);
			System.out.println("Current ObjectDetails:" + cCellData);
			System.out.println("Current ObjectDetailsPath:" + ORvalue);
			System.out.println("Current Action:" + dCellData);
			System.out.println("------Error Information : Open2Test-------");
			fail("Cannot test normally by Open2Test.");
			// return;
		}
	}

	public void readAttributeforPerform() throws Exception {
		try {
			if (ObjectSetVal.length() > 0) {
				if (ObjectSetVal.substring(0, 1).equalsIgnoreCase("#")) {
					ObjectSetVal = map.get(ObjectSetVal.substring(1,
							(ObjectSetVal.length())));
				} else if (ObjectSetVal.contains("dt_")) {
					String ObjectSetValtableheader[] = ObjectSetVal.split("_");
					int column = 0;
					String Searchtext = ObjectSetValtableheader[1];
					for (column = 0; column < DTcolumncount; column++) {
						if (Searchtext.equalsIgnoreCase(DTsheet.getCell(column,
								0).getContents()) == true) {
							ObjectSetVal = DTsheet.getCell(column, dtrownum)
									.getContents();
							iflag = 1;
						}

					}
					if (iflag == 0) {
						ORvalname = "exit";
					}
				}
			}
		} catch (Exception e) {
			Update_Report("failed", e);
		}

	}

	public void dCellAction() throws Exception {
		try {
			readAttributeforPerform();
			Func_FindObj(ORvalname, ORvalue);
			if (elem == null) {
				return;
			} else {
				switch (ObjectSet.toLowerCase()) {
				case "set":
					elem.clear();
					StringBuffer inputvalue = new StringBuffer();
					inputvalue.append(ObjectSetVal);
					((RemoteWebDriver) D8).executeScript(
							"arguments[0].value=arguments[0].value + '"
									+ inputvalue.toString() + "';", elem);

					Update_Report("executed");
					if (captureperform == true) {
						screenshot(loopnum, TScrowcount, TScname);
					}
					break;
				case "listselect":

					Func_FindObj(ORvalname, ORvalue);
					String[] listvalues = ObjectSetVal.split(",");
					List<WebElement> listboxitems = elem.findElements(By
							.tagName("option"));
					Select chooseoptn = new Select(elem);
					chooseoptn.deselectAll();
					for (WebElement opt : listboxitems) { // System.out.println(opt.getText());
						for (int i = 0; i < listvalues.length; i++) {
							if (opt.getText().equalsIgnoreCase(listvalues[i])) {
								// System.out.println(listvalues[i]);
								chooseoptn.selectByVisibleText(opt.getText());
							}
						}
					}
					Update_Report("executed");
					if (captureperform == true) {
						screenshot(loopnum, TScrowcount, TScname);
					}

					break;

				case "select":
					// readAttributeforPerform();
					// Func_FindObj(ORvalname, ORvalue);
					new Select(elem).selectByVisibleText(ObjectSetVal);
					Update_Report("executed");
					if (captureperform == true) {
						screenshot(loopnum, TScrowcount, TScname);
					}

					break;

				case "check":
					// readAttributeforPerform();
					// Func_FindObj(ORvalname, ORvalue);
					if (elem.isSelected()
							&& dCellDataVal[1].equalsIgnoreCase("On")) {

					} else if (elem.isSelected()
							|| dCellDataVal[1].equalsIgnoreCase("On")) {
						elem.click();
					}
					Update_Report("executed");
					if (captureperform == true) {
						screenshot(loopnum, TScrowcount, TScname);
					}
					break;

				case "click":
					// Func_FindObj(ORvalname, ORvalue);
					elem.click();

					Update_Report("executed");
					if (captureperform == true) {
						screenshot(loopnum, TScrowcount, TScname);
					}
					break;

				case "clear":
					// Func_FindObj(ORvalname, ORvalue);
					elem.clear();

					Update_Report("executed");
					if (captureperform == true) {
						screenshot(loopnum, TScrowcount, TScname);
					}
					break;
				}
			}
		} catch (Exception e) {
			Update_Report("failed", e);
		}
	}

	public static boolean isInteger(String input) {
		try {
			Integer.parseInt(input);
			return true;
		} catch (Exception e) {
			return false;
		}
	}
}
