package scattergather

import akka.actor.{Supervisor, Actor, ActorRef}
import akka.config.Supervision._
import akka.dispatch.Dispatchers
import java.util.concurrent.ThreadPoolExecutor.CallerRunsPolicy

object AdaptiveSearchTreeMain {
  def submitInitialDocuments(searchNode: ActorRef) =
    Seq("Trochę przykładowych danych",
		"Jeszcze więcej przykładowych danych",
		"Być albo nie być, oto jest pytanie",
		"OMG to kot!",
		"To przykład. Naprawdę świetny.",
		"HAI there", "HAI IZ HUNGRY",
		"Witaj, świecie",
		"Witaj, witamy w węzle wyszukiwawczym nr 8",
		"Leniwy brązowy lis przeskoczył nad",
		"Wygrywanie jest najlepsze, bo to wygrywanie!"
    ) foreach (doc =>  searchNode ! SearchableDocument(doc))
  def makeTree = {
    val supervisor = Supervisor(SupervisorConfig(AllForOneStrategy(List(classOf[Exception]), 3, 1000), Nil))
    val searchnodedispatcher = Dispatchers.newExecutorBasedEventDrivenDispatcher("adaptujące się drzewo wyszukiwawcze")
        .withNewThreadPoolWithLinkedBlockingQueueWithCapacity(100)
        .setCorePoolSize(10)
        .setMaxPoolSize(128)
        .setKeepAliveTimeInMillis(60000)
        .setRejectionPolicy(new CallerRunsPolicy)
        .build
    val searchTree = Actor.actorOf(new AdaptiveSearchNode {
      self.dispatcher = searchnodedispatcher
    })
    supervisor link searchTree
    searchTree.start()
    submitInitialDocuments(searchTree)
    searchTree
  }
}

object SearchTreeMain {
  def create(name: String) = {
    val supervisor = Supervisor(SupervisorConfig(AllForOneStrategy(List(classOf[Exception]), 3, 1000), Nil))
    val searchnodedispatcher = Dispatchers.newExecutorBasedEventDrivenDispatcher("drzewo wyszukiwawcze [" + name + "]")
      .withNewThreadPoolWithLinkedBlockingQueueWithCapacity(100)
      .setCorePoolSize(10)
      .setMaxPoolSize(128)
      .setKeepAliveTimeInMillis(60000)
      .setRejectionPolicy(new CallerRunsPolicy)
      .build
    val leafNodes = (1 to 10).map(i => Actor.actorOf(new SearchNode(i) {
      self.dispatcher = searchnodedispatcher
    }))
    leafNodes foreach supervisor.link
    leafNodes foreach (_.start())
    val headNode = Actor.actorOf(new HeadNode {
      override val nodes = leafNodes
      self.dispatcher = searchnodedispatcher
    })
    supervisor link headNode
    headNode.start()
    headNode
  }

  def makeResponder = {
    val tmp = Actor.actorOf(new Actor {
      def receive = {
        case x => println(x)
      }
    })
    tmp.start()
    tmp
  }

}
