package chapter10

object Intelligence extends App {
  type Rating = Int
  type NumericString = String // Ciąg tekstowy, który można skonwertować na wartość typu Int!
  type AlphaNumeric = String  // Alfanumeryczny ciąg tekstowy.

  trait ActionGenerator[In] {
    type Out

    def generateAction(): Out
  }

  val simpleRatingGenerator = new ActionGenerator[NumericString] {
    type Out = NumericString => Rating

   /* Ocena na podstawie zwykłego egzemplarza NumericStrings.
    * Dostępne oceny to 1, 2, 3, 4, 5.
    * Nie interesują nas liczby większe niż 5.
    */
    override def generateAction(): NumericString => Rating = _.toInt
  }

  val alphanumericRatingGenerator = new ActionGenerator[AlphaNumeric] {
    type Out = AlphaNumeric => Rating

   /* Ocena na podstawie komentarza takiego jak świetny, super, dobry lub innego bardziej neutralnego.
    * Dostępne oceny to 1, 2, 3, 4, 5.
    */
    override def generateAction(): AlphaNumeric => Rating = toRating // Pewien inny mechanizm przeznaczony do wygenerowania oceny.
  }

  val toRating: AlphaNumeric => Rating = _ match {
    case "wspaniały" => 5
    case "świetny"    => 4
    case "dobry"    => 3
    case "najgorszy na świecie" => 1
    case _ => 3 // Brak komentarza oznacza ocenę przeciętną.
  }

  val generateNumericRating = simpleRatingGenerator.generateAction()
  val generateAlphanumericRating = alphanumericRatingGenerator.generateAction()

  println(generateNumericRating("1"))
  println(generateAlphanumericRating("wspaniały"))
}

trait ActionGenerator[In] {
  type Out

  def generateAction(): Out
}

object RatingApp extends App {

  type Rating = Int
  type NumericString = String // Ciąg tekstowy, który można skonwertować na wartość typu Int!
  type AlphaNumeric = String  // Alfanumeryczny ciąg tekstowy.

  val simpleRatingGenerator = new ActionGenerator[NumericString] {
    type Out = NumericString => Rating

    /* Ocena na podstawie zwykłego egzemplarza NumericStrings.
     * Dostępne oceny to 1, 2, 3, 4, 5.
     * Nie interesują nas liczby większe niż 5.
     */
    override def generateAction(): NumericString => Rating = _.toInt
  }

  val generateNumericRating = simpleRatingGenerator.generateAction()

  println(generateNumericRating("1"))
}