package chapter9

import scala.annotation.tailrec

object TailRecursion {
  def main(args: Array[String]): Unit = {
      val list = List("Aleksander", "Bartek", "Cezary", "Dawid", "Romek", "Sławek")
    someRecursiveMethod(list)
  }

  /*
      Mamy posortowaną listę imion pracowników firmy.
      Mają zostać wyświetlone wszystkie aż do napotkania imienia "Romek".
  */
  @tailrec
  def someRecursiveMethod(list: List[String]): Unit = {
      list match {
        case Nil => println(s"Nie można kontynuować działania. Wyświetlono wszystkie imiona lub napotkano imię Romek.")
        case head :: tail => if(head != "Romek") {
          println(s"Imię: $head")
          someRecursiveMethod(tail)
        } else someRecursiveMethod(Nil)
      }
  }
}