package example

import scala.util.Try
import scala.util.{Failure, Success}

object PlayerService extends App {

  def readPlayerDataFromSource(src: String): List[String] = {
    val source = io.Source.fromFile(src)

    val list: List[String] = source.getLines().toList

    source.close()
    list
  }

  def parseToPlayer(string: String): Option[Player] = {
    Try {
      val columns = string.split((",")).map(_.trim)
      Player(columns(5), columns(6), columns(9).toInt, columns(7))
    } match {
      case Success(value) => Some(value)
      case Failure(excep) => None
    }
  }

  case class Player(name: String, nationality: String, age: Int, league:
String)
}
