package example

import rx.lang.scala.Observable

object SmartApp extends App {

  val src = "/Users/vika/Documents/LSProg/LSPWorkspace/First_Proj_Rx/src/main/scala/example/football_stats.csv"

  val playerObservable: Observable[String] =
    Observable.from(PlayerService.readPlayerDataFromSource(src))

  val somePlayer = Some(PlayerService.Player("Losowo wybrany zawodnik", "Losowo wybrana narodowość", 31, "Losowo wybrana liga"))

  playerObservable
    .map(playerString =>
      PlayerService.parseToPlayer(playerString))
    .merge(Observable.just(somePlayer))
    .subscribe(player => PlayerService.showPlayerInformation(player),
      error => println(s"Wystąpił błąd: ${error.getMessage}"))

  Thread.sleep(10000)
}
