package chapter5

object RestFullAPIs extends App {
    // Lista metod i adresów URI.
    val listOfAPIs = List(("GET", "/user/:id"),
                          ("GET", "user/:id/profile/:p_id"),
                          ("POST", "/user"),
                          ("POST", "/profile"),
                          ("PUT", "/user/:id"))

    /*
     * Zwraca egzemplarz scala.collection.immutable.Map[String, List[(String,String)]]
     */
    val groupedListOfAPIs = listOfAPIs.groupBy(_._1)
    println(s"API grupowane na obiekt Map :: $groupedListOfAPIs")

    /*
     * Zwraca egzemplarz scala.collection.immutable.Map[String, List[String]]
     */
    val apisByMethod = groupedListOfAPIs.mapValues(_.map(_._2))
    println(s"API według metod :: $apisByMethod")
}
