

class Computer 
  attr_accessor :display
  attr_accessor :motherboard
  attr_reader   :drives

  def initialize(display=:crt, motherboard=Motherboard.new, drives=[])
    @motherboard = motherboard
    @drives = drives
    @display = display
  end
end

class CPU
  # Typowe dane opisujce procesor
end

class BasicCPU < CPU
  # Mnstwo informacji o przecitnym procesorze
end

class TurboCPU < CPU
  # Mnstwo informacji o bardzo szybkim procesorze
end

class Motherboard
  attr_accessor :cpu
  attr_accessor :memory_size

  def initialize(cpu=BasicCPU.new, memory_size=1000)
    @cpu = cpu
    @memory_size = memory_size
  end
end


class Drive
  attr_reader :type # :hard_disk, :cd lub :dvd
  attr_reader :size # pojemno wyraona w megabajtach
  attr_reader :writable  # true, jeli dany napd umoliwia zapis

  def initialize(type, size, writable)
    @type = type
    @size = size
    @writable = writable
  end
end

