#!/usr/bin/env ruby

require '../example'

example %q{

hello = lambda do
  puts('Witaj')
  puts('Jestem wewntrz obiektu Proc.')
end

hello.call
}


example %q{

name = 'Jan'
proc = Proc.new do
  name = 'Maria'
end

proc.call
puts(name)

}


example %q[

hello = lambda {
  puts('Witaj, jestem wewntrz obiektu Proc.')
}

]


example %q[
hello = lambda { puts('Witaj, jestem wewntrz obiektu Proc.')}
]


example %q[
return_24 = lambda {24}
puts(return_24.call)
]


example %q[

multiply = lambda {| x, y | x * y}

n = multiply.call(20, 3)
puts(n)
n = multiply.call(10, 50)
puts(n)

]


example %q[
def run_it
  puts('Przed wykonaniem yield')
  yield
  puts('Po wykonaniu yield')
end


run_it do
  puts('Witaj')
  puts('Przybywam do Ciebie z wntrza bloku kodu')
end

]


example %q[
def run_it_with_parameter
  puts('Przed wykonaniem yield')
  yield(24)
  puts('Po wykonaniu yield')
end

run_it_with_parameter do |x|
  puts('Przybywam do Ciebie z wntrza bloku kodu')
  puts("Parametr x ma warto #{x}")
end
]


example %q[
def run_it_with_parameter(&block)
  puts('Przed wykonaniem call')
  block.call(24)
  puts('Po wykonaniu call')
end

my_proc = lambda {|x| puts("Parametr x ma warto #{x}")}

run_it_with_parameter(&my_proc)

]
