
require 'etc'

class AccountProtectionProxy
  def initialize(real_account, owner_name)
    @subject = real_account
    @owner_name = owner_name
  end


  def method_missing(name, *args)
    check_access
    @subject.send( name, *args )
  end

  def check_access
    if Etc.getlogin != @owner_name 
      raise "Bd dostpu: #{Etc.getlogin} nie ma dostpu do rachunku."
    end
  end
end

