#!/usr/bin/env ruby

require 'test/unit'
require 'pp'

require 'ex5_change_class'

class ModifiedBTOClassTest < Test::Unit::TestCase

  def test_text_object
    t = TextObject.new( 'witaj', 0.25, :blue)
  end

  def test_british_text_object
    t = BritishTextObject.new( 'witaj', 25.4, :blue)

    assert_equal 'witaj', t.string
    assert_equal 25.4, t.size_mm
    assert_equal :blue, t.colour

    assert_equal 'witaj', t.text
    assert_equal 1, t.size_inches
    assert_equal :blue, t.color
  end

  def test_renderer
    t = BritishTextObject.new( 'pozdrowienia', 25.4, :red)
    r = Renderer.new

    assert_equal 'pozdrowienia/1.0/red', r.render(t)
  end


end




