#!/usr/bin/env ruby

require '../example'

example %q{

h = {'nazwisko'=>'Ryba', 'oczy'=>'niebieskie', 'pe'=>'mczyzna'}
h.each_key {|key| puts key}

}

example %q{
h = {'nazwisko'=>'Ryba', 'oczy'=>'niebieskie', 'pe'=>'mczyzna'}

h.each_value {|value| puts value}
}

example %q{
h = {'nazwisko'=>'Ryba', 'oczy'=>'niebieskie', 'pe'=>'mczyzna'}

h.each {|key, value| puts "#{key} #{value}"}
}

example %q{
f = File.open('names.txt')
while not f.eof?
  puts f.readline 
end
f.close
}


example %q{
f = File.open('names.txt')
f.each {|line| puts(line)}
f.close
}


example %q{
f = File.open('short.txt')
f.each_byte {|byte| puts(byte)}
}



example_trunc %q{
require 'pathname'

pn = Pathname.new('/usr/local/lib/ruby/1.8')

pn.each_filename {|file| puts "Plik: #{file}"}
}

example_trunc %q{
pn = Pathname.new('/usr/local/lib/ruby/1.8')

pn.each_entry {|entry| puts "Element: #{entry}"}
}

example_trunc %q{
ObjectSpace.each_object {|object|  puts "Obiekt: #{object}"}
}

example_trunc %q{
ObjectSpace.each_object(Numeric) {|n| puts "Znaleziono liczb #{n}"}
}


example_trunc %q{
def subclasses_of(superclass)
  subclasses = []
  ObjectSpace.each_object(Class) do |k|
    next if !k.ancestors.include?(superclass) || superclass == k ||
             k.to_s.include?('::') || subclasses.include?(k.to_s)
    subclasses << k.to_s
  end
  subclasses
end

pp subclasses_of(Numeric)
}
