class Task
  attr_reader :name

  def initialize(name)
    @name = name
  end

  def get_time_required
    0.0
  end
end

class AddDryIngredientsTask < Task 

  def initialize
    super('Dodaj suche skadniki')
  end

  def get_time_required
    1.0             # Dodanie mki i cukru zajmuje 1 minut.
  end
end

class MixTask < Task 

  def initialize
    super('Wymieszaj mas!')
  end
  
  def get_time_required
    3.0             # Mieszanie masy zajmuje 3 minuty.
  end
end

class AddLiquidsTask < Task 

  def initialize
    super('Dodaj pyny')
  end
  
  def get_time_required
    4.0
  end
end

