#!/usr/bin/env ruby

require '../example'

example %q{

require 'rexml/parsers/sax2parser'
require 'rexml/sax2listener'

#
# Tworzymy dla naszych danych analizator skadniowy XML-u.
#
xml = File.read('data.xml')
parser = REXML::Parsers::SAX2Parser.new( xml )

#
# Dodajemy kilka obserwatorw nasuchujcych elementw pocztkowych i kocowych
#
parser.listen( :start_element ) do |uri, local, qname, attrs|
  puts "element pocztkowy: #{local}"
end

parser.listen( :end_element ) do |uri, local, qname|
  puts "element kocowy: #{local}"
end

#
# Analizujemy dane w formacie XML.
#
parser.parse


}
