
class Report
  attr_reader :title, :text

  attr_accessor :formatter

  def initialize(formatter)
    @title = 'Raport miesiczny'
    @text =  [ 'Wszystko idzie', 'naprawd dobrze.' ]
    @formatter = formatter
  end

  def output_report
    @formatter.output_report(self)
  end
end


class Formatter
  def output_report(context)
    raise 'Wywoano metod abstrakcyjn'
  end
end

class HTMLFormatter < Formatter
  def output_report(context)
    puts('<html>')
    puts('  <head>')
    puts("    <title>#{context.title}</title>")
    puts('  </head>')
    puts('  <body>')
    context.text.each do |line|
      puts("    <p>#{line}</p>")
    end
    puts('  </body>')
    puts('</html>')
  end
end

class PlainTextFormatter < Formatter
  def output_report(context)
    puts("***** #{context.title} *****")
    context.text.each do |line|
      puts(line)
    end
  end
end

