
class Report
  def initialize
    @title = 'Raport miesiczny'
    @text =  ['Wszystko idzie', 'naprawd dobrze.']
  end

  def output_report
    output_start
    output_head
    output_body_start
    output_body
    output_body_end
    output_end
  end

  def output_body
    @text.each do |line|
      output_line(line)
    end
  end

  def output_start
    raise 'Wywoano metod abstrakcyjn output_start'
  end

  def output_head
    raise 'Wywoano metod abstrakcyjn output_head'
  end

  def output_body_start
    raise 'Wywoano metod abstrakcyjn output_body_start'
  end

  def output_line(line)
    raise 'Wywoano metod abstrakcyjn output_line'
  end

  def output_body_end
    raise 'Wywoano metod abstrakcyjn output_body_end'
  end

  def output_end
    raise 'Wywoano metod abstrakcyjn output_end'
  end
end



class HTMLReport < Report
  def output_start
    puts('<html>')
  end

  def output_head
    puts('  <head>')
    puts("    <title>#{@title}</title>")
    puts('  </head>')
  end

  def output_body_start
    puts('<body>')
  end

  def output_line(line)
    puts("  <p>#{line}</p>")
  end

  def output_body_end
    puts('</body>')
  end

  def output_end
    puts('</html>')
  end
end

class PlainTextReport < Report
  def output_start
  end

  def output_head
    puts("**** #{@title} ****")
    puts
  end

  def output_body_start
  end

  def output_line(line)
    puts line
  end 

  def output_body_end
  end

  def output_end
  end
end


