# Skrypt 7.1 - wood.rb

# Klasa reprezentujca zbir desek.
class Wood

  # Dostp do-odczytu do tablicy boards:
  attr_reader :boards

  # Konstruktor, moe inicjalizowa tablic boards.
  def initialize(*args)
    @boards = args
  end
  
  # Metoda dodaje pojedyncz deseczk.
  def add_board(board)
    @boards.push(board)
  end
  
  # Metoda zwraca cakowit powierzchni desek.
  def total
    t = 0
    @boards.each { |b| t += (b[:width] * b[:length]) }
    t
  end
  
  # Metoda sprawdzajca, czy wystarczy drewna 
  # dla danego projektu
  def enough?(project)
    project.total <= self.total
  end
  
  # Operator dodawania:
  def +(rh)
    @boards += rh.boards
    self
  end
  
  # Operator przyrwnania:
  def ==(rh)
    self.total == rh.total
  end
  
  # Operator identyczno:
  def ===(rh)
    @boards == rh.boards
  end
  
  # Oglny operator porwnania:
  def <=>(rh)
    if self.total < rh.total then -1
    elsif self.total > rh.total then 1
    else 0 end
  end
  
end # Koniec definicji klasy Wood.

# Utwrz nowy obiekt typu Wood:
maple = Wood.new({:width => 7, :length => 42}, {:width => 4.5, :length => 22}, {:width => 6.75, :length => 32.5}, {:width => 5, :length => 26.25})

# Utwrz drugi obiekt typu Wood:
oak = Wood.new
oak.add_board({:width => 5, :length => 26.25})
oak.add_board({:width => 6.25, :length => 27.5})

# Kilka testw:
print "Cakowita powierzchnia desek z klonu: "
puts maple.total
print "Cakowita powierzchnia desek dbowych: "
puts oak.total
print "Czy cakowite powierzchnie desek z klonu i dbowych s rwne? "
puts maple == oak
print "Porwnanie cakowitych powierzchni desek z klonu i dbowych: "
puts maple <=> oak

# Kup wicej desek dbowych:
oak += Wood.new({:width => 7, :length => 19}, {:width => 5.5, :length => 22.2})

# Sprawd czy wystarczy dla projektu:
table = Wood.new({:width => 4.5, :length => 22}, {:width => 6.75, :length => 32.5}, {:width => 5, :length => 26.25}, {:width => 5, :length => 26.25})
print "Wymagana powierzchnia dla stou: "
puts table.total
print "Czy wystarczy desek z klonu? "
puts maple.enough?(table) ? "Do pracy!": "Niestety!"
print "Czy wystarczy desek dbowych? "
puts oak.enough?(table) ? "Do pracy!": "Niestety!"