# Skrypt 7.3 - ducks.rb

# Bardzo prosta definicja klasy Rectangle:
class Rectangle

  attr_reader :height, :width

  def initialize(h, w)
    @height, @width = h, w
  end

  def area
    @height * @width
  end
  
  # + powinien dziaa jedynie z innymi obiektami Rectangle!
  def +(rh)
    return nil unless rh.instance_of? Rectangle
    @height += rh.height
    @width += rh.width
    self
  end
  
  # Porwnywa mona z kadym obiektem ktry
  # posiada metod "area".
  def <=>(rh)
    return nil unless rh.respond_to?('area')
    if (self.area < rh.area) then -1
    elsif (self.area > rh.area) then 1
    else 0 end
  end
  
end # Koniec definicji klasy Rectangle.

# Prosta definicja klasy Circle:
class Circle
  attr_reader :radius
  def initialize(r)
    @radius = r
  end
  def area
    Math::PI * @radius**2
  end
end # Koniec definicji klasy Circle.

# Utwrz obiekty:
r = Rectangle.new(32, 56)
c = Circle.new(8.4)

# Wywietl informacj o nich:
puts "Pole r wynosi #{r.area}. Pole c wynosi #{c.area}."

# Wywietl sum:
print "Wynik dodawania r + c: "
puts r + c

# Wywietl wynik porwnania:
print "Porwnanie r z c: "
puts r <=> c

