# Skrypt 12.2 - employees.rb

# Docz biblioteki:
require 'rubygems'
require 'highline/import'

# Definiuj modu:
module Employees

  # Metoda rozpoczynajca cay proces:
  def Employees.start
    Employees.create_menu
  end

  # Metoda tworzca menu:
  def Employees.create_menu

    # Linia rozdzielajca:
    puts '---------------------'

    # Utwrz menu:
    choose do |m|
      m.prompt = 'Wybierz opcj: '
      m.choice(:'Dodaj pracownika') { Employees.add_employee }
      m.choice(:'Wywietl dane wszystkich pracownikw') { Employees.view_employees }
      m.choice(:'Wyjcie') { Process.exit }
    end

  end # Koniec create_menu

  # Metoda dodajca pracownikw:
  def Employees.add_employee

    # Linia rozdzielajca:
    puts '---------------------'

    # Pobierz dane:
    fname = ask('Podaj Imi: ') { |q| q.validate = /\A[a-z .'-]+\Z/i }
    lname = ask('Podaj Nazwisko: ') { |q| q.validate = /\A[a-z .'-]+\Z/i }
    id = ask('Podaj numer identyfikatora: ', Integer) { |q| q.above = 0 }

    # Sprawd czy doda kolejnego pracownika:
    Employees.add_employee if agree('Czy doda kolejnego pracownika? ')

    # Utwrz menu:
    Employees.create_menu

  end # Koniec add_employee

  # Metoda wywietlajca dane pracownikw:
  def Employees.view_employees

    # Linia rozdzielajca:
    puts '---------------------'

    puts 'Tutaj powinny zosta wywietlone dane wszystkich pracownikw.'
    Employees.create_menu
  end

end # Koniec moduu Employees.

# Uruchom modu:
Employees.start
