# Skrypt 7.2 - groceries.rb

# Definicja nowej klasy:
class GroceryList

  # Konstruktor tworzy pusty hasz.
  def initialize
    @items = Hash.new
  end
  
  # Metoda dodajca elementy do listy.
  # Ilo jest opcjonalna, domylnie 1.
  # Nazwa elementu jest uywana jako klucz.
  def add(item, qty = 1)
    @items[item] = qty
  end
  
  # Metoda suca do iterowania po elementach listy.
  # Zwraca klucz i warto.
  def each
    @items.each_pair { |k, v| yield k, v }
  end
  
  def to_s
  	str = ''
    @items.each_pair { |k, v| str += "#{k}: #{v}, "}
    str.slice(0, str.length - 2).to_s
  end
  
end # Koniec definicji klasy GroceryList.

# Utwrz now list:
g = GroceryList.new

# Dodaj kilka elementw:
g.add('cukier', '5kg')
g.add('kiwi', 4)
g.add('stek')

# Wywietl list jako cig znakw:
puts "Lista jako cig znakw=> " + g.to_s

# Wywietl kady element listy w nowym wierszu:
puts "Lista zakupw"
g.each { |item, qty| puts "#{qty} #{item}" }