require 'pdf/writer'
require 'pdf/simpletable'

#Inicjowanie nowego obiektu typu PDF.
pdf = PDF::Writer.new
#Podobnie jak w wikszoci edytorw tekstu moesz wybra czcionk.
pdf.select_font("Times-Roman") #Courier, Helvetica, Symbol, Times-Roman, ZapfDingbats
pdf.text("Recenzja: Ruby. Skrypty\n\n", :font_size => 25, :justification => :center)

#Tworzenie tabeli w dokumencie PDF.
PDF::SimpleTable.new do |table|
  table.column_order = %w(question response)
  
  table.columns["question"] = PDF::SimpleTable::Column.new("question") do |col|
    col.heading = "Pytanie"
    col.width = 100
  end
  
  table.columns["response"] = PDF::SimpleTable::Column.new("response") do |col|
    col.heading = "Odpowiedz"
  end
  #Atrybuty tabeli.
  table.show_lines    = :all
  table.show_headings = false
  table.shade_rows    = :none
  table.orientation   = :center
  table.position      = :center
  table.width	    = 400
  
  #Struktura haszujca data --- w razie potrzeby dodaj pytania.
  data = [
    {"question" => "Recenzent:"},
    {"question" => "Tytul:", "response" => "Ruby. Skrypty"},
    {"question" => "Autor:", "response" => "Steven Pugh"},
    {"question" => "Wydawca i rok:", "response" => "Helion, 2009"},
    {"question" => "ISBN:"},
    {"question" => "Gatunek:", "response" => "Jezyki programowania: Ruby"},
  ]
  table.data.replace data
  table.render_on(pdf) 
end

#Demonstracja generowania tekstu w dokumencie pdf.
pdf.text("\n\n1. Czy ta pozycja nauczyla Cie czegos o pisaniu skryptow w Ruby (zakresl
jedna odpowiedz)?" , :font_size => 14)
pdf.text("\n Tak   Nie    Dlaczego?____________________________")
pdf.text("\n2. Czy przykladowe skrypty sa przydatne i dobrze opisane?")
pdf.text("\n Tak   Nie    Dlaczego?____________________________")
pdf.text("\n3. Czy polecilbys te ksiazke innym czytelnikom? Dlaczego?")
pdf.text("    ________________________________________________________________")
pdf.text("    ________________________________________________________________")
pdf.text("\n4. Podaj trzy przymiotniki opisujace te ksiazke:")
pdf.text("    a._______________  b._______________ c._______________")
pdf.text("\n5. Tu wpisz dodatkowe uwagi:")
pdf.text("    ________________________________________________________________")
pdf.text("    ________________________________________________________________")
pdf.text("    ________________________________________________________________")
pdf.text("    ________________________________________________________________")
pdf.text("    ________________________________________________________________")
pdf.text("\n6. Ocena - zaznacz jedna (0=Okropna, 5=Odjazdowa):")
pdf.text("           0             1            2            3            4            5")
#This shows how 
pdf.circle_at(66, pdf.y+5, 5).stroke
pdf.circle_at(121, pdf.y+5, 5).stroke
pdf.circle_at(170, pdf.y+5, 5).stroke
pdf.circle_at(219, pdf.y+5, 5).stroke
pdf.circle_at(268, pdf.y+5, 5).stroke
pdf.circle_at(316, pdf.y+5, 5).stroke

pdf.save_as('book_review.pdf')
