require 'RMagick'           #Potrzebna do manipulowania zdjciami.
require 'ftools'            #Potrzebna do utworzenia katalogw.
include Magick              #Jestem zbyt leniwy, aby dodawa przedrostek Magick:: przed kad metod biblioteki RMagick.

photos_row = 4
table_border = 1
html_rows = 1

#Tworzenie potrzebnych katalogw.
File.makedirs("gallery/thumbs", "gallery/resize")
output = File.new("gallery/index.html","w+b")

output.puts <<EOF
<html>
    <head>
        <title>Zdjcia</title>
    </head>
    <body bgcolor="#d0d0d0">
        <h1>Witaj w galerii fotografii</h1>
        <table border=#{table_border}>
EOF

Dir['*.[Jj][Pp]*[Gg]'].each do |pic|
  #Tworzenie miniatur.
  thumb = Image.read(pic)[0]
  thumb.change_geometry!('150x150') do |cols, rows, img|
    thumb.resize!(cols, rows)
  end
  if File.exists?("gallery/thumbs/th_#{pic}")
    puts "Nie mona zapisa pliku th_#{pic} - miniatura ju istnieje. Zmiana nazwy na new_th_#{pic}"
    thumb.write "gallery/thumbs/new_th_#{pic}"
  else
    thumb.write "gallery/thumbs/th_#{pic}"
  end

  #Zmienianie wymiarw zdjcia.
  resize = Image.read(pic)[0]
  resize.change_geometry!('800x600') do |cols, rows, img|
    resize.resize!(cols, rows)
  end
  if File.exists?("gallery/resize/resize_#{pic}")
    puts "Nie mona zapisa pliku resize_#{pic} - zdjcie o zmienionych wymiarach ju istnieje. Zmiana nazwy na new_resize_#{pic}"
    resize.write("gallery/resize/new_resize_#{pic}")
  else
    resize.write("gallery/resize/resize_#{pic}")
  end
    
  if html_rows % photos_row == 1
    output.puts "\n<tr>"
  end
    
  output.puts <<EOF
        <td><a href="resize/resize_#{pic}/" title="#{pic}" target="_blank"><img src="thumbs/th_#{pic}" alt="#{pic}"/></a></td>
EOF
        
  if html_rows % photos_row == 0
    output.puts "</tr>"
  end
  html_rows+=1
end

unless html_rows % photos_row == 1
  output.puts "</tr>"
end

output.puts "</body>\n</html>"
output.puts "<!-- Dziki uprzejmoci No Starch Press (skrypt z ksiki Wicked Cool Ruby Scripts) -->"
output.close
