require 'benchmark'

#Sortowanie przez wybieranie w jzyku Ruby.
def selection_sort(a)
  a.each_index do |i|
    min_index = min(a, i)
    
    a[i], a[min_index] = a[min_index], a[i]
    
  end
  a
end

def min(subset, from)
  min_value = subset[from..-1].min
  min_index = subset[from..-1].index(min_value) + from
  return min_index
end

#System testowy podaje liczby do sortowania (zakadamy, e plik tekstowy zawiera 1000 losowo uporzdkowanych wartoci).
big_array = Array.new
big_array_sorted = Array.new
IO.foreach("1000RanNum.txt", $\ = ' ') {|num| big_array.push num.to_i }

#Wywietlanie czasu sortowania (trzeba wywoa bibliotek Benchmark w celu pomiaru czasu i posortowa dane).
puts Benchmark.measure {big_array_sorted = selection_sort(big_array)}

File.open("output_selection_sort.txt","w") do |out|
  out.puts big_array_sorted
end
