# == Opis programu
# 
#  file_security: szyfruje i odszyfrowuje pliki; ilustruje algorytmy szyfrowania
# 
# 
# == Sposb uycia
# 
# encryption [OPCJE] ... PLIK
# 
# -h, --help:
#   Wywietla pomoc
# 
# --encrypt klucz, -e klucz
#    Szyfruje plik przy uyciu hasa
# 
# --decrypt klucz, -d klucz
#    Odszyfrowuje plik przy uyciu hasa
# 
# PLIK: Plik, ktry chcesz zaszyfrowa lub odszyfrowa

require 'getoptlong'
require 'rdoc/ri/ri_paths'
require 'rdoc/usage'
require 'crypt/blowfish'

def encrypt(file, pass)
  c = "Encrypted_#{file}"
            
  if File.exists?(c)
    puts "\nPlik ju istnieje."
    exit
  end
    
  begin
    # Inicjowanie metody szyfrujcej przy uyciu klucza podanego przez uytkownika.
    blowfish = Crypt::Blowfish.new(pass)
    blowfish.encrypt_file(file.to_str, c)
    # Szyfrowanie pliku.
    puts "\nSzyfrowanie zakoczone sukcesem!"
  rescue Exception => e
    puts "W czasie szyfrowania wystpi bd: \n #{e}"
  end
end

def decrypt(file, pass)
  p = "Decrypted_#{file}"

  if File.exists?(p)
    puts "\nPlik ju istnieje."
    exit
  end

  begin
    # Inicjowanie metody odszyfrowujcej przy uyciu klucza podanego przez uytkownika.
    blowfish = Crypt::Blowfish.new(pass)
    blowfish.decrypt_file(file.to_str, p)
    # Odszyfrowywanie pliku.
    puts "\nOdszyfrowywanie zakoczone sukcesem!"
  rescue Exception => e
    puts "W czasie odszyfrowywania wystpi bd: \n #{e}"
  end
end

#Definicje wszystkich argumentw przyjmowanych w wierszu polece.
opts = GetoptLong.new(
  [ '--help', '-h', GetoptLong::NO_ARGUMENT ],
  [ '--encrypt', '-e', GetoptLong::REQUIRED_ARGUMENT ],
  [ '--decrypt', '-d', GetoptLong::REQUIRED_ARGUMENT ]
)

unless ARGV[0]
  puts "\nNie podae nazwy pliku (wyprbuj opcj --help)"
  exit
end

filename = ARGV[-1].chomp

#Bloki powizane z rnymi argumentami z wiersza polece.
opts.each do |opt, arg|
  case opt
  when '--help'
    RDoc::usage
  when '--encrypt'
    encrypt(filename, arg)
  when '--decrypt'
    decrypt(filename, arg)
  else
    RDoc::usage
  end
end
