require "open-uri"

unless ARGV[0]
  puts "Musisz poda definiowane sowo."
  puts "Sposb uycia: ruby define.rb <definiowane sowo>"
  exit
end

word = ARGV[0].strip

#Adres URL, pod ktrym skrypt szuka definicji.
url = "http://dictionary.reference.com/browse/#{word}"

begin
  open(url) do |source|
    #Wyszukiwanie definicji w kodzie rdowym.
    source.each_line do |x|
      if x =~ /No results found/
        puts "\nDefinicji nie znaleziono - sprawd pisowni."
        exit
      end
      #Jeli znaleziono definicj, skrypt dopasuje ponisze wyraenie regularne.
      if x =~ /(1\.)<\/td> <td>(.*)<\/td/
        puts "\n#{$1} #{$2}"
        exit
      end
    end
    puts "Niestety nie mona znale definicji."
  end
rescue => e
  puts "Wystpi bd - sprbuj ponownie."
  puts e
end
