require 'find'
require 'digest/md5'

unless ARGV[0] and File.directory?(ARGV[0])
  puts "\n\n\nMusisz poda katalog gwny:  changedFiles.rb <katalog>\n\n\n"	
  exit
end


#Inicjowanie wszystkich zmiennych uywanych w skrypcie.
root = ARGV[0]
oldfile_hash = Hash.new
newfile_hash = Hash.new
file_report = "#{root}/analysis_report.txt"
file_output = "#{root}/file_list.txt"
oldfile_output = "#{root}/file_list.old"

#Jeli istniej starsze dane, trzeba je pobra i zapisa
#w tablicy haszujcej w celu pniejszego porwnania.
if File.exists?(file_output)
  File.rename(file_output, oldfile_output)       
  File.open(oldfile_output, 'rb') do |infile|
    while (temp = infile.gets)
      line = /(.+)\s{5,5}(\w{32,32})/.match(temp)
      puts "#{line[1]}  --->  #{line[2]}"
      oldfile_hash[line[1]] = line[2]
    end
  end
end

#Przechodzenie przez katalog i obliczanie kodw MD5 Hash do
#momentu przetworzenia wszystkich plikw.
Find.find(root) do |file|
  next if /^\./.match(file)
  next unless File.file?(file)
  begin
    newfile_hash[file] = Digest::MD5.hexdigest(File.read(file))
  rescue
    puts "Bd odczytu pliku #{file} --- nie obliczono kodu MD5."
  end
end


#Inicjowanie plikw na dane.
report = File.new(file_report, 'wb')
changed_files = File.new(file_output, 'wb')

#Zapisywanie znalezionych plikw w pliku changed.files.
newfile_hash.each do |file, md5|
  changed_files.puts "#{file}     #{md5}"
end


#Usuwanie identycznych plikw z tablicy haszujcej.
newfile_hash.keys.select { |file| newfile_hash[file] == oldfile_hash[file] }.each do |file|
  newfile_hash.delete(file)
  oldfile_hash.delete(file)
end


#Zapisywanie zmienionych i dodanych plikw oraz usuwanie ich z tablicy.
newfile_hash.each do |file, md5|
  report.puts "#{oldfile_hash[file] ? "Zmodyfikowano" : "Dodano"} file: #{file}     #{md5}"
  oldfile_hash.delete(file)
end


#Zapisywanie pozostaych plikw w tablicy oldfile_hash table - tych dokumentw nie znaleziono w podanej ciece.
oldfile_hash.each do |file, md5|
  report.puts "Usunito/Przeniesiono plik: #{file}     #{md5}"
end

report.close
changed_files.close
