require 'openssl'
require 'socket'
require 'digest/sha1'

priv_key = OpenSSL::PKey::RSA.new(1024)
pub_key = priv_key.public_key

host = ARGV[0] || 'localhost'
port = (ARGV[1] || 8887).to_i

#Uruchamianie odbiorczego serwera TCP przy uyciu adresu ip i portu.
server = TCPServer.new(host, port)

#Jeli klient nawie poczenie, naley wysa klucz publiczny i czeka na dane.
while session = server.accept
  begin
    puts "Nawizano poczenie...trwa wysyanie klucza publicznego.\n\n"
    puts pub_key
    session.print pub_key
    puts "Przesano klucz publiczny - trwa oczekiwanie na dane...\n\n"
        
    temp = session.recv(10000)
    puts "Otrzymano dano..."
        
    msg = priv_key.private_decrypt(temp)
  rescue => e
    puts "Wystpi powany bd przy pobieraniu i odszyfrowywaniu danych."
    puts e
  end
    
  #Podzia komunikatu wysanego przez klienta.
  command = msg.split("*")
    
  serv_hash = command[0]
  nix_app = command[1]
  win_app = command[2]
  file = command[3]

  #Urchomienie komunikatu dostosowanego do uywanego systemu.
  if Digest::SHA1.hexdigest("#{nix_app}*#{win_app}*#{file}")==serv_hash
    puts "Potwierdzono integralno komunikatu..."
    if RUBY_PLATFORM.include?('mswin32')
      puts "Uruchamianie polecenia dla systemu Windows: #{win_app} #{file}"
      `#{win_app} #{file}`
      exit
    else
      puts "Uruchamianie polecenia dla systemu Linux: #{nix_app} #{file}"
      `#{nix_app} #{file}`
      exit
    end
  else
    puts "Nie mona przeprowadzi walidacji komunikatu!"
  end
  exit
end
